package com.netease.yanxuan.wx.store.sharer.integration.handler;

import com.alibaba.fastjson.JSON;
import com.netease.yanxuan.wx.store.sharer.common.exception.BizException;
import com.netease.yanxuan.wx.store.sharer.common.handler.RestTemplateClient;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

/**
 * @Description RestTemplateClient
 * @Author fanjiaxin
 * @Date 2025/3/11 17:27
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RestTemplateHandler {
    private final RestTemplateClient restTemplateClient;


    /**
     * 执行操作
     */
    public <T, R> R execute(String url, HttpMethod method, T params, Class<R> resType) {
        try {
            String resultJson = restTemplateClient.execute(url, method, params);
            return JSON.parseObject(resultJson, resType);
        } catch (Exception e) {
            throw new BizException(e);
        }
    }
}

