package com.netease.yanxuan.wx.store.sharer.common.handler;

import com.alibaba.fastjson.JSON;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import java.net.URI;
import java.util.Map;

/**
 * @Description RestTemplateClient
 * @Author fanjiaxin
 * @Date 2025/3/11 17:27
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RestTemplateClient implements HttpRequestClient {
    private final RestTemplate restTemplate;

    @Override
    public <T, R> R execute(String url, HttpMethod method, T params, Class<R> resType) {
        log.info("RestTemplateClient execute url:{},method:{},params:{}", url, method, JSON.toJSONString(params));
        if (method == HttpMethod.GET) {
            return handleGetRequest(url, params, resType);
        } else {
            return handlePostRequest(url, params, resType);
        }
    }

    private <T, R> R handleGetRequest(String url, T params, Class<R> resType) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl(url);
        Map<String, Object> paramsMap = JSON.parseObject(JSON.toJSONString(params), Map.class);
        paramsMap.forEach(builder::queryParam);
        URI uri = builder.build().toUri();
        log.info("RestTemplateClient handleGetRequest execute uri:{}", uri);
        ResponseEntity<R> response = restTemplate.getForEntity(url, resType, paramsMap);
        log.info("RestTemplateClient handleGetRequest execute response:{}", JSON.toJSONString(response));
        return response.getBody();
    }

    private <T, R> R handlePostRequest(String url, T params, Class<R> resType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<T> requestEntity = new HttpEntity<>(params, headers);
        ResponseEntity<R> response = restTemplate.postForEntity(url, requestEntity, resType);
        log.info("RestTemplateClient handlePostRequest execute response:{}", JSON.toJSONString(response));
        return response.getBody();
    }
}

