package com.netease.yanxuan.wx.store.sharer.integration.handler.impl;

import com.netease.yanxuan.wx.store.sharer.integration.config.WeChatConfig;
import com.netease.yanxuan.wx.store.sharer.integration.constant.WeChatApi;
import com.netease.yanxuan.wx.store.sharer.integration.handler.IWeChatRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.WeChatRestTemplateHandler;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.WeChatSharerRegisterBindBO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatSharerRegisterBindVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

/**
 * @Description 微信凭证请求
 * @Author fanjiaxin
 * @Date 2025/3/11 17:33
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class WeChatSharerRegisterBindRequest implements IWeChatRequest {
    private final WeChatRestTemplateHandler weChatRestTemplateHandler;
    private final WeChatConfig weChatConfig;


    @Override
    public HttpMethod getRequestMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getRequestUrl() {
        return weChatConfig.getUrl() + WeChatApi.GET_PROMOTER_REGISTER_AND_BIND_STATUS + "?access_token=" + getAccessToken();
    }

    /**
     * 处理
     */
    public WeChatSharerRegisterBindVO handle(String sharerOpenid) {
        WeChatSharerRegisterBindBO params = WeChatSharerRegisterBindBO.builder()
                .is_simple_register(true)
                .sharer_openid(sharerOpenid)
                .build();
        return weChatRestTemplateHandler.execute(getRequestUrl(), getRequestMethod(), params, WeChatSharerRegisterBindVO.class);
    }
}
