package com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description 商品推广链接-业务对象
 * @Author fanjiaxin
 * @Date 2025/3/11 18:43
 */
@Data
@Builder
public class WeChatPromoteProductLinkBO implements Serializable {
    private static final long serialVersionUID = 1996751915518651231L;

    /**
     * 推客 appid，和sharer_openid二选一
     */
    private String sharer_appid;
    /**
     * 推客在小程序中的openid，和sharer_appid二选一
     */
    private String sharer_openid;
    /**
     * 商品 id，如果使用该参数，需要传入shop_appid
     */
    private Integer product_id;
    /**
     * 商品所属店铺 appid
     */
    private String shop_appid;
    /**
     * 商品短链，和 product_id 二选一
     */
    private String product_short_link;
}
