package com.netease.yanxuan.wx.store.sharer.biz.config;

import com.netease.yanxuan.wx.store.sharer.biz.interceptor.AuthInterceptor;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.ArrayList;
import java.util.Collections;

/**
 * @Description 配置
 * @Author fanjiaxin
 * @Date 2025/3/10 10:54
 */
@Configuration
@RequiredArgsConstructor
public class WebConfig implements WebMvcConfigurer {
    private final AuthInterceptor authInterceptor;

    private static final String[] EXCLUDE_URLS = {"/sharer/open/**",
            "/sharer/test/**", "/sharer/i/health", "/sharer/user/login",
            "/sharer/product/page/list"};

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(authInterceptor)
                .addPathPatterns(getIncludePathPatterns())
                .excludePathPatterns(getExcludePathPatterns());
    }

    /**
     * 需要用户和服务认证判断的路径
     */
    private ArrayList<String> getIncludePathPatterns() {
        ArrayList<String> list = new ArrayList<>();
        String[] urls = {"/**"};
        Collections.addAll(list, urls);
        return list;
    }

    /**
     * 白名单
     */
    private ArrayList<String> getExcludePathPatterns() {
        ArrayList<String> list = new ArrayList<>();
        Collections.addAll(list, EXCLUDE_URLS);
        return list;
    }
}
