package com.netease.yanxuan.wx.store.sharer.integration.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.netease.yanxuan.wx.store.sharer.common.exception.BizException;
import com.netease.yanxuan.wx.store.sharer.common.handler.RestTemplateClient;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

/**
 * @Description RestTemplateClient
 * @Author fanjiaxin
 * @Date 2025/3/11 17:27
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class RestTemplateHandler {
    private final RestTemplateClient restTemplateClient;

    /**
     * 执行操作
     */
    public <T, R> R execute(String url, HttpMethod method, T params, Class<R> resType) {
        try {
            log.info("[op:RestTemplateHandler.execute] url:{} params:{}", url, JSONObject.toJSONString(params));
            String resultJson = restTemplateClient.execute(url, method, params);
            log.info("[op:RestTemplateHandler.execute] result:{}", resultJson);
            return JSON.parseObject(resultJson, resType);
        } catch (Exception e) {
            log.info("[op:RestTemplateHandler.execute] is error", e);
            throw new BizException(e);
        }
    }
}

