package com.netease.yanxuan.wx.store.sharer.biz.job;

import com.netease.mail.yanxuan.dschedule.core.biz.model.ReturnT;
import com.netease.mail.yanxuan.dschedule.core.handler.IJobHandler;
import com.netease.mail.yanxuan.dschedule.core.handler.annotation.JobHandler;
import com.netease.yanxuan.wx.store.sharer.biz.service.ICommissionOrderService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @Description 微信小店佣金单数据同步任务
 * @Author fanjiaxin
 * @Date 2025/3/27 19:08
 */
@Slf4j
@RequiredArgsConstructor
@Component
@JobHandler("weChatCommissionOrderSyncJob")
public class WeChatCommissionOrderSyncJob extends IJobHandler {

    private final ICommissionOrderService iCommissionOrderService;


    @Override
    public ReturnT<String> execute(String... strings) {
        log.info("[op:weChatCommissionOrderSyncJob] start...");
        Long syncStartTimestamp = iCommissionOrderService.getLatestCommissionSyncTimestamp();
        long syncEndTimestamp = System.currentTimeMillis() / 1000;
        iCommissionOrderService.doCommissionOrderSync(syncStartTimestamp, syncEndTimestamp);
        log.info("[op:weChatCommissionOrderSyncJob] end...");
        return ReturnT.SUCCESS;
    }
}
