package com.netease.yanxuan.wx.store.sharer.biz.core;

import com.alibaba.fastjson.JSON;
import com.netease.yanxuan.wx.store.sharer.common.constant.CoreConstant;
import com.netease.yanxuan.wx.store.sharer.common.handler.RedisClient;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

/**
 * @Description 微信认证信息上下文持有器
 * @Author fanjiaxin
 * @Date 2025/2/24 11:53
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class LoginUserHelper {
    private final RedisClient redisClient;

    /**
     * 获取用户认证信息
     */
    public LoginUserInfo getLoginUserInfo(String token) {
        String loginUserInfoJson = redisClient.getStr(CoreConstant.REDIS_TOKEN_USER_KEY + token);
        log.info("LoginUserHelper getLoginUserInfo loginUserInfoJson:{}", loginUserInfoJson);
        if (StringUtils.isNotBlank(loginUserInfoJson)) {
            return JSON.parseObject(loginUserInfoJson, LoginUserInfo.class);
        }
        return null;
    }

    /**
     * 保存用户认证信息
     */
    public void setLoginUserInfo(String token, String sharerAppId) {
        LoginUserInfo loginUserInfo = getLoginUserInfo(token);
        loginUserInfo.setSharerAppId(sharerAppId);
        setLoginUserInfo(token, loginUserInfo);
    }

    /**
     * 保存用户认证信息
     */
    public void setLoginUserInfo(String token, String openId, String sharerAppId) {
        LoginUserInfo loginUserInfo = new LoginUserInfo();
        loginUserInfo.setAccessToken(token);
        loginUserInfo.setOpenId(openId);
        loginUserInfo.setSharerAppId(sharerAppId);
        setLoginUserInfo(token, loginUserInfo);
    }

    /**
     * 保存用户认证信息
     */
    public void setLoginUserInfo(String token, LoginUserInfo loginUserInfo) {
        redisClient.setStr(CoreConstant.REDIS_TOKEN_USER_KEY + token,
                JSON.toJSONString(loginUserInfo), CoreConstant.REDIS_TOKEN_EXPIRE_SECONDS);
    }
}
