package com.netease.yanxuan.wx.store.sharer.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.netease.yanxuan.wx.store.sharer.biz.config.DrmSharerConfig;
import com.netease.yanxuan.wx.store.sharer.biz.core.LoginUserContextHolder;
import com.netease.yanxuan.wx.store.sharer.biz.core.LoginUserHelper;
import com.netease.yanxuan.wx.store.sharer.biz.core.LoginUserInfo;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.bo.LoginBO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo.SharerInfoVO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo.UserCommissionRatioVO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo.UserTokenVO;
import com.netease.yanxuan.wx.store.sharer.biz.service.IUserService;
import com.netease.yanxuan.wx.store.sharer.common.exception.NoBindSharerException;
import com.netease.yanxuan.wx.store.sharer.dal.mapper.SharerInfoMapper;
import com.netease.yanxuan.wx.store.sharer.dal.meta.model.po.SharerInfo;
import com.netease.yanxuan.wx.store.sharer.integration.constant.WeChatApi;
import com.netease.yanxuan.wx.store.sharer.integration.handler.impl.WeChatShopSetSharerCommissionRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.impl.WeChatShopSharerListRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.impl.WeChatShopSharerRegisterBindRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.impl.WeChatUserInfoRequest;
import com.netease.yanxuan.wx.store.sharer.integration.meta.enums.CommissionTypeEnum;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatSharerInfoVO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatSharerListVO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatSharerRegisterBindVO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatUserInfoVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * @Description 用户-业务实现类
 * @Author fanjiaxin
 * @Date 2025/3/10 12:31
 */
@Slf4j
@RequiredArgsConstructor
@Service
public class UserServiceImpl implements IUserService {

    private final SharerInfoMapper sharerInfoMapper;
    private final LoginUserHelper loginUserHelper;
    private final WeChatUserInfoRequest weChatUserRequest;
    private final WeChatShopSharerRegisterBindRequest weChatShopSharerRegisterBindRequest;
    private final WeChatShopSharerListRequest weChatShopSharerListRequest;
    private final WeChatShopSetSharerCommissionRequest weChatShopSetSharerCommissionRequest;
    private final DrmSharerConfig drmSharerConfig;


    @Override
    public UserTokenVO login(LoginBO bo) {
        Date now = new Date();
        // 获取用户信息
        WeChatUserInfoVO userInfoVO = weChatUserRequest.handle(bo.getCode());
        // 获取本地用户信息
        LambdaQueryWrapper<SharerInfo> sharerInfoLqw = Wrappers.lambdaQuery();
        sharerInfoLqw.eq(SharerInfo::getOpenId, userInfoVO.getOpenid());
        sharerInfoLqw.last("LIMIT 1");
        SharerInfo sharerInfo = sharerInfoMapper.selectOne(sharerInfoLqw);
        if (null == sharerInfo) {
            sharerInfo = new SharerInfo();
            sharerInfo.setOpenId(userInfoVO.getOpenid());
            // 默认佣金比例
            sharerInfo.setCommissionRatio(drmSharerConfig.getDefaultCommissionRatio().toPlainString());
            sharerInfo.setCommissionType(CommissionTypeEnum.PLATFORM.getCode());
            sharerInfo.setCreateTime(now);
            sharerInfo.setUpdateTime(now);
            sharerInfoMapper.insert(sharerInfo);
        }
        // 生成token
        String token = LoginUserContextHolder.generateToken(bo.getCode(), sharerInfo.getOpenId());
        loginUserHelper.setLoginUserInfo(token, sharerInfo.getOpenId(), null);
        return UserTokenVO.builder().token(token).build();
    }

    @Override
    public SharerInfoVO refreshUserInfo() {
        LoginUserInfo loginUserInfo = LoginUserContextHolder.get();
        // 获取本地用户信息
        LambdaQueryWrapper<SharerInfo> sharerInfoLqw = Wrappers.lambdaQuery();
        sharerInfoLqw.eq(SharerInfo::getOpenId, loginUserInfo.getOpenId());
        sharerInfoLqw.last("LIMIT 1");
        SharerInfo sharerInfo = sharerInfoMapper.selectOne(sharerInfoLqw);
        SharerInfoVO result = getSharerRegisterBindInfo(loginUserInfo.getOpenId());
        // 初始化保存
        if (null == sharerInfo) {
            sharerInfo = new SharerInfo();
            sharerInfo.setOpenId(loginUserInfo.getOpenId());
        }
        WeChatSharerInfoVO sharerInfoVO;
        Date now = new Date();
        // 用户分佣比例
        BigDecimal sharerCommissionRatio = drmSharerConfig.getSharerCommissionRatioOrDefault(loginUserInfo.getOpenId());
        // 已绑定
        if (SharerInfoVO.bindStatus.BIND.getCode().equals(result.getBindStatus())) {
            // 获取绑定信息
            WeChatSharerListVO sharerListVO = weChatShopSharerListRequest.handle(loginUserInfo.getOpenId(), "", 1);
            if (null != sharerListVO && !CollectionUtils.isEmpty(sharerListVO.getSharer_info_list())) {
                sharerInfoVO = sharerListVO.getSharer_info_list().get(0);
                if (null != sharerInfoVO) {
                    // 判断默认分佣比例是否相同，不相同更新默认分佣比例
                    if (sharerCommissionRatio.compareTo(sharerInfoVO.getCommission_ratio()) != 0) {
                        // 更新默认分佣比例
                        BigDecimal commissionRatio = sharerCommissionRatio
                                .multiply(new BigDecimal(WeChatApi.WECHAT_COMMISSION_RATIO_MULTIPLIER))
                                .setScale(0, RoundingMode.DOWN);
                        // 设置推客分佣比例
                        weChatShopSetSharerCommissionRequest.handle(sharerInfoVO.getSharer_appid(),
                                commissionRatio.longValue());
                    }
                    result.setSharerAppId(sharerInfoVO.getSharer_appid());
                    sharerInfo.setSharerAppid(sharerInfoVO.getSharer_appid());
                    Date bindTime = null != sharerInfoVO.getBind_time() ? new Date(sharerInfoVO.getBind_time()) : now;
                    sharerInfo.setBindTime(bindTime);
                    // 微信分佣比例倍数
                    BigDecimal wechatMultiplier = new BigDecimal(WeChatApi.WECHAT_COMMISSION_RATIO_MULTIPLIER);
                    BigDecimal commissionRatio = sharerInfoVO.getCommission_ratio()
                            .divide(wechatMultiplier)
                            .setScale(2, RoundingMode.HALF_UP);
                    sharerInfo.setCommissionRatio(commissionRatio.toPlainString());
                    Integer commissionType = null != sharerInfoVO.getCommission_type() ? sharerInfoVO.getCommission_type() : CommissionTypeEnum.PLATFORM.getCode();
                    sharerInfo.setCommissionType(commissionType);
                    // 刷新缓存
                    loginUserHelper.setLoginUserInfo(loginUserInfo.getAccessToken(), sharerInfoVO.getSharer_appid());
                }
            }
        }
        // 初始化保存
        if (null == sharerInfo.getId()) {
            // 默认佣金比例
            sharerInfo.setCommissionRatio(sharerCommissionRatio.toPlainString());
            sharerInfo.setCommissionType(CommissionTypeEnum.PLATFORM.getCode());
            sharerInfo.setCreateTime(now);
            sharerInfo.setUpdateTime(now);
            sharerInfoMapper.insert(sharerInfo);
        } else {
            sharerInfo.setUpdateTime(now);
            sharerInfoMapper.updateById(sharerInfo);
        }
        return result;
    }

    @Override
    public SharerInfoVO getUserInfo() {
        LoginUserInfo loginUserInfo = LoginUserContextHolder.get();
        SharerInfoVO result = getSharerRegisterBindInfo(loginUserInfo.getOpenId());
        // 获取本地用户信息
        LambdaQueryWrapper<SharerInfo> sharerInfoLqw = Wrappers.lambdaQuery();
        sharerInfoLqw.eq(SharerInfo::getOpenId, loginUserInfo.getOpenId());
        sharerInfoLqw.last("LIMIT 1");
        SharerInfo sharerInfo = sharerInfoMapper.selectOne(sharerInfoLqw);
        // 已经绑定
        if (null != sharerInfo && StringUtils.isNotBlank(sharerInfo.getSharerAppid())) {
            result.setSharerAppId(sharerInfo.getSharerAppid());
        }
        return result;
    }

    @Override
    public UserCommissionRatioVO getCommissionRatioDefault() {
        BigDecimal defaultCommissionRatio = drmSharerConfig.getDefaultCommissionRatio();
        return UserCommissionRatioVO.builder().commissionRatio(defaultCommissionRatio).build();
    }

    @Override
    public void bindCommissionRatioDefault() {
        // 获取用户信息
        LoginUserInfo loginUserInfo = LoginUserContextHolder.get();
        if (StringUtils.isBlank(loginUserInfo.getSharerAppId())) {
            throw new NoBindSharerException("未绑定推客");
        }
        BigDecimal sharerCommissionRatio = drmSharerConfig.getSharerCommissionRatio(loginUserInfo.getOpenId());
        BigDecimal commissionRatio = sharerCommissionRatio
                .multiply(new BigDecimal(WeChatApi.WECHAT_COMMISSION_RATIO_MULTIPLIER))
                .setScale(0, RoundingMode.DOWN);
        // 设置推客分佣比例
        weChatShopSetSharerCommissionRequest.handle(loginUserInfo.getSharerAppId(),
                commissionRatio.longValue());
    }

    private SharerInfoVO getSharerRegisterBindInfo(String openId) {
        // 获取推客注册与绑定信息
        WeChatSharerRegisterBindVO sharerRegisterBindVO = weChatShopSharerRegisterBindRequest.handle(openId);
        SharerInfoVO result = new SharerInfoVO();
        result.setOpenId(openId);
        result.setBindStatus(sharerRegisterBindVO.getBind_status());
        result.setRegisterStatus(sharerRegisterBindVO.getRegister_status());
        result.setRegisterBusinessType(sharerRegisterBindVO.getRegister_business_type());
        result.setRegisterQueryString(sharerRegisterBindVO.getRegister_query_string());
        result.setBindBusinessType(sharerRegisterBindVO.getBind_business_type());
        result.setBindQueryString(sharerRegisterBindVO.getBind_query_string());
        return result;
    }
}
