package com.netease.yanxuan.wx.store.sharer.assembly;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.annotation.ComponentScan;

import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import com.netease.yanxuan.missa.client.annotation.EnableMissaClients;

/**
 * 项目启动类
 */
@ComponentScan(basePackages = "com.netease.yanxuan.wx.store.sharer")
@EnableApolloConfig
@EnableMissaClients(basePackages = "com.netease.yanxuan.wx.store.sharer")
@MapperScan(basePackages = "com.netease.yanxuan.wx.store.sharer.dal.mapper")
@SpringBootApplication
public class Application extends SpringBootServletInitializer {

    public static void main(String[] args) throws Exception {
        SpringApplication.run(Application.class, args);
    }
}
