package com.netease.yanxuan.wx.store.sharer.integration.handler.impl;

import com.netease.yanxuan.wx.store.sharer.integration.config.WeChatConfig;
import com.netease.yanxuan.wx.store.sharer.integration.constant.WeChatApi;
import com.netease.yanxuan.wx.store.sharer.integration.core.WeChatContextHolder;
import com.netease.yanxuan.wx.store.sharer.integration.handler.IWeChatRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.WeChatRestTemplateHandler;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.WeChatSharerListBO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatSharerListVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

/**
 * @Description 获取机构绑定的推客信息
 * @Author fanjiaxin
 * @Date 2025/3/11 17:33
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class WeChatShopSharerListRequest implements IWeChatRequest {
    private final WeChatContextHolder weChatContextHolder;
    private final WeChatRestTemplateHandler weChatRestTemplateHandler;
    private final WeChatConfig weChatConfig;


    @Override
    public HttpMethod getRequestMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getRequestUrl() {
        return weChatConfig.getUrl() + WeChatApi.GET_BIND_SHARER_LIST
                + "?" + WeChatApi.WECHAT_REQUEST_TOKEN_FIELD_NAME + "="
                + weChatContextHolder.getShopAccessToken();
    }

    /**
     * 处理
     */
    public WeChatSharerListVO handle(String sharerOpenid, String nextKey, Integer pageSize) {
        WeChatSharerListBO params = WeChatSharerListBO.builder()
                .sharer_openid(sharerOpenid)
                .next_key(nextKey)
                .page_size(pageSize)
                .build();
        return weChatRestTemplateHandler.execute(getRequestUrl(), getRequestMethod(), params, WeChatSharerListVO.class);
    }
}
