/**
 * @(#)UasClientImpl.java, 2022/7/27.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.yanxuan.wx.store.sharer.integration.client.impl;

import com.netease.yanxuan.userinfo.client.meta.CommonResult;
import com.netease.yanxuan.wx.store.sharer.integration.client.IUserInfoClient;
import com.netease.yanxuan.wx.store.sharer.integration.facade.UserInfoFacade;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.UserInfoVerifyByIdentityNoBO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;


@Slf4j
@RequiredArgsConstructor
@Service
public class UserInfoClientImpl implements IUserInfoClient {
    private final UserInfoFacade userInfoFacade;

    @Override
    public Boolean verifyByIdentityNo(String realName, String identityNo) {
        log.info("[op:verifyByIdentityNo] realName:{}, identityNo:{}", realName, identityNo);
        try {
            UserInfoVerifyByIdentityNoBO bo = UserInfoVerifyByIdentityNoBO.builder().realName(realName).identityNo(identityNo).build();
            CommonResult<Boolean> result = userInfoFacade.verifyByIdentityNo(bo);
            if (HttpStatus.OK.value() == result.getCode()) {
                return result.getResult();
            }
        } catch (Exception e) {
            log.error("[op:verifyByIdentityNo] is exception", e);
        }
        return false;
    }
}
