package com.netease.yanxuan.wx.store.sharer.integration.handler.impl;

import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.netease.yanxuan.wx.store.sharer.integration.config.WeChatConfig;
import com.netease.yanxuan.wx.store.sharer.integration.constant.WeChatApi;
import com.netease.yanxuan.wx.store.sharer.integration.core.WeChatContextHolder;
import com.netease.yanxuan.wx.store.sharer.integration.handler.IWeChatRequest;
import com.netease.yanxuan.wx.store.sharer.integration.handler.WeChatRestTemplateHandler;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.WeChatSharerRegisterBindBO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatSharerRegisterBindVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description 微信凭证请求
 * @Author fanjiaxin
 * @Date 2025/3/11 17:33
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class WeChatShopSharerRegisterBindRequest implements IWeChatRequest {
    private final WeChatContextHolder weChatContextHolder;
    private final WeChatRestTemplateHandler weChatRestTemplateHandler;
    private final WeChatConfig weChatConfig;


    @Override
    public HttpMethod getRequestMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getRequestUrl() {
        return weChatConfig.getUrl() + WeChatApi.GET_PROMOTER_REGISTER_AND_BIND_STATUS
                + "?" + WeChatApi.WECHAT_REQUEST_TOKEN_FIELD_NAME + "="
                + weChatContextHolder.getShopAccessToken();
    }

    /**
     * 处理
     */
    public WeChatSharerRegisterBindVO handle(String sharerOpenid) {
        WeChatSharerRegisterBindBO params = WeChatSharerRegisterBindBO.builder()
                .is_simple_register(true)
                .sharer_openid(sharerOpenid)
                .build();
        log.info("[op:WeChatShopSharerRegisterBindRequest.handle]  requestParam={}", JSONObject.toJSONString(params));
        WeChatSharerRegisterBindVO res = weChatRestTemplateHandler.execute(getRequestUrl(), getRequestMethod(), params, WeChatSharerRegisterBindVO.class);
        log.info("[op:WeChatShopSharerRegisterBindRequest.handle]  res={}", JSONObject.toJSONString(res));
        return res;
    }
}
