package com.netease.yanxuan.wx.store.sharer.biz.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * 线程池配置类
 *
 * @author fanjiaxin
 * @date 2024/6/12 15:55
 */
@Slf4j
@Configuration
@EnableAsync
public class ExecutorConfig {

    /**
     * 异步线程池
     */
    @Bean(name = "asyncProductListServiceExecutor")
    public Executor asyncProductListServiceExecutor() {
        log.info("start asyncProductListServiceExecutor...");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        //配置核心线程数
        executor.setCorePoolSize(10);
        //配置最大线程数
        executor.setMaxPoolSize(20);
        //配置队列大小
        executor.setQueueCapacity(500);
        //线程空闲时间
        executor.setKeepAliveSeconds(30);
        //配置线程池中的线程的名称前缀
        executor.setThreadNamePrefix("async-product-list-service-executor-");
        /**
         * rejection-policy：当pool已经达到max size的时候，如何处理新任务
         * CALLER_RUNS：不在新线程中执行任务，而是有调用者所在的线程来执行
         */
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        //等待所有任务完成再关闭
        executor.setWaitForTasksToCompleteOnShutdown(true);
        //最长等待时间，秒
        executor.setAwaitTerminationSeconds(60);
        //初始化执行器
        executor.initialize();
        return executor;
    }
}
