package com.netease.yanxuan.wx.store.sharer.web.controller;

import com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo.ProductListVO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo.ProductPromotionLinkVO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.page.PageQuery;
import com.netease.yanxuan.wx.store.sharer.biz.meta.page.PageVO;
import com.netease.yanxuan.wx.store.sharer.biz.service.IProductService;
import com.netease.yanxuan.wx.store.sharer.common.core.Result;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatGetSharerProductCommissionVO;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.vo.WeChatSharerListVO;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description 商品-控制器
 * @Author fanjiaxin
 * @Date 2025/3/9 13:21
 */
@RequiredArgsConstructor
@RestController
@RequestMapping("/sharer/product")
public class ProductController extends BaseController {
    private final IProductService iProductService;


    /**
     * 商品分页列表
     */
    @GetMapping("/page/list")
    public Result<PageVO> getProductPageList(PageQuery pageQuery,
                                             @RequestParam(value = "keyword", required = false) String keyword) {
        PageVO<ProductListVO> pageList = iProductService.getProductPageList(pageQuery, keyword);
        return Result.ok(pageList);
    }


    /**
     * 商品分享短链
     */
    @GetMapping("/promotion/link")
    public Result<ProductPromotionLinkVO> getProductPromotionLink(@RequestParam("shopAppid") String shopAppid,
                                                                  @RequestParam("productId") String productId) {
        ProductPromotionLinkVO promotionLink = iProductService.getProductPromotionLink(shopAppid, productId);
        return Result.ok(promotionLink);
    }

    /**
     * 获取获取机构绑定的推客信息
     */
    @GetMapping("/bind/sharer/list")
    public Result<WeChatSharerListVO> getBindSharerList(@RequestParam("sharerOpenid") String sharerOpenid) {
        WeChatSharerListVO result = iProductService.getBindSharerList(sharerOpenid);
        return Result.ok(result);
    }

    /**
     * 获取推客的某个商品的推广分佣比例
     */
    @GetMapping("/sharer/product/commission")
    public Result<WeChatGetSharerProductCommissionVO> getSharerProductCommissionInfo(@RequestParam("sharerAppid") String sharerAppid,
                                                                                     @RequestParam("productId") String productId) {
        WeChatGetSharerProductCommissionVO result = iProductService.getSharerProductCommissionInfo(sharerAppid, productId);
        return Result.ok(result);
    }
}
