package com.netease.yanxuan.wx.store.sharer.biz.interceptor;

import com.netease.yanxuan.wx.store.sharer.biz.core.LoginUserContextHolder;
import com.netease.yanxuan.wx.store.sharer.biz.core.LoginUserHelper;
import com.netease.yanxuan.wx.store.sharer.biz.core.LoginUserInfo;
import com.netease.yanxuan.wx.store.sharer.common.constant.CoreConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @Description 用户信息拦截器
 * @Author fanjiaxin
 * @Date 2025/3/10 10:20
 */
@Slf4j
@RequiredArgsConstructor
@Component
public class UserInterceptor implements HandlerInterceptor {
    private final LoginUserHelper loginUserHelper;


    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String token = request.getHeader(CoreConstant.AUTH_HEADER_TOKEN_KEY);
        LoginUserInfo loginUserInfo = loginUserHelper.getLoginUserInfo(token);
        if (null != loginUserInfo) {
            // 刷新缓存
            loginUserHelper.setLoginUserInfo(token, loginUserInfo);
            LoginUserContextHolder.set(loginUserInfo);
        }
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response,
                                Object handler, Exception ex) {
        LoginUserContextHolder.remove();
    }
}
