/**
 * @(#)UasClientImpl.java, 2022/7/27.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.yanxuan.wx.store.sharer.integration.client.impl;

import com.alibaba.fastjson.JSON;
import com.netease.yanxuan.missa.specs.interfaces.response.MissaResponse;
import com.netease.yanxuan.wx.store.sharer.integration.client.IUasClient;
import com.netease.yanxuan.wx.store.sharer.integration.facade.UasFacade;
import com.netease.yanxuan.wx.store.sharer.integration.meta.model.bo.SmsCodeScenesConfigBO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;


@Slf4j
@RequiredArgsConstructor
@Service
public class UasClientImpl implements IUasClient {

    private final UasFacade uasFacade;

    private static final String TOPIC_FORMAT = "verify_%s";

    /**
     * 发送验证码
     *
     * @param phone  手机号码
     * @param code   验证码
     * @param scenes 业务场景标识
     * @return
     */
    @Override
    public boolean sendSmsCode(String uid, String phone, String code,
                               String scenes, SmsCodeScenesConfigBO scenesConfigBO) {
        Map<String, Object> params = assembleSmsArg(uid, phone, code, scenes, scenesConfigBO);
        log.error("[op:UasClientImpl:sendSmsCode] params:{}", JSON.toJSONString(params));
        try {
            MissaResponse<Void> missaResponse = uasFacade.pushSmsCode(params);
            log.error("[op:UasClientImpl:sendSmsCode] rpcResult:{}", JSON.toJSONString(missaResponse));
            if (null == missaResponse) {
                return false;
            }
            if (missaResponse.isOK()) {
                return true;
            }
        } catch (Exception e) {
            log.error("[op:UasClientImpl:sendSmsCode] is error", e);
        }
        return false;
    }


    private Map<String, Object> assembleSmsArg(String uid, String phone,
                                               String code, String scenes,
                                               SmsCodeScenesConfigBO scenesConfigBO) {
        Map<String, Object> params = new HashMap<>();
        params.put("phone", phone);
        params.put("message", String.format(scenesConfigBO.getMessageFormat(), code, scenesConfigBO.getCodeValidMinutes()));
        params.put("level", 1);
        params.put("uid", uid);
        params.put("topic", String.format(TOPIC_FORMAT, scenes));
        return params;
    }
}
