package com.netease.yanxuan.wx.store.sharer.integration.config;

import com.ctrip.framework.apollo.spring.annotation.EnableAutoUpdateApolloConfig;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @Description 应用配置
 * @Author fanjiaxin
 * @Date 2025/3/10 17:26
 */
@Data
@Component
@EnableAutoUpdateApolloConfig
public class SmsConfig {
    /**
     * 验证码发送最大次数
     */
    @Value("${sms.send.max.count:10}")
    private Integer sendMaxCount;

    /**
     * 验证码发送间隔时间，秒
     */
    @Value("${sms.send.interval.seconds:60}")
    private Integer sendIntervalSeconds;

    /**
     * 验证码有效时间，单位秒
     */
    @Value("${sms.code.valid.seconds:300}")
    private Integer codeValidSeconds;

    /**
     * 验证码短信格式
     */
    @Value("${sms.message.format:}")
    private String messageFormat;

    /**
     * 验证码每日校验次数上限
     */
    @Value("${sms.verify.code.max.count:10}")
    private Integer verifyCodeMaxCount;
}