package com.netease.yanxuan.wx.store.sharer.web.controller;

import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.netease.yanxuan.wx.store.sharer.biz.meta.model.bo.LoginBO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo.SharerInfoVO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo.UserCommissionRatioVO;
import com.netease.yanxuan.wx.store.sharer.biz.meta.model.vo.UserTokenVO;
import com.netease.yanxuan.wx.store.sharer.biz.service.IUserService;
import com.netease.yanxuan.wx.store.sharer.common.core.Result;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * @Description 用户-控制器
 * @Author fanjiaxin
 * @Date 2025/3/9 13:10
 */
@RequiredArgsConstructor
@RestController
@RequestMapping("/sharer/user")
@Slf4j
public class UserController extends BaseController {
    private final IUserService iUserService;

    /**
     * 登录
     */
    @PostMapping("/login")
    public Result<UserTokenVO> login(@Validated @RequestBody LoginBO bo) {
        UserTokenVO result = iUserService.login(bo);
        return Result.ok(result);
    }

    /**
     * 刷新用户信息
     */
    @PostMapping("/refreshUserInfo")
    public Result<SharerInfoVO> refreshUserInfo() {
        SharerInfoVO result = iUserService.refreshUserInfo();
        return Result.ok(result);
    }

    /**
     * 用户信息
     */
    @PostMapping("/getUserInfo")
    public Result<SharerInfoVO> getUserInfo() {
        SharerInfoVO result = iUserService.getUserInfo();
        return Result.ok(result);
    }

    /**
     * 查询平台默认的分佣比例
     */
    @PostMapping("/getCommissionRatioDefault")
    public Result<UserCommissionRatioVO> getCommissionRatioDefault() {
        UserCommissionRatioVO result = iUserService.getCommissionRatioDefault();
        return Result.ok(result);
    }
}
