/**
 * @(#)RandomUtils.java, 2022/7/25.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.yanxuan.wx.store.sharer.common.util;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

/**
 * @author 张艳(wb.zhangyan12 @ mesg.corp.netease.com)
 */
public class RandomUtils {

    private static final String CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    private static final String NUMBER = "0123456789";

    /**
     * 获取随机字符串
     *
     * @param length 生成的随机字符串长度
     * @return 返回随机字符串
     */
    public static String randomString(int length) {
        return randomString(CHARS, length);
    }

    /**
     * 获取随机数字字符串
     *
     * @param length
     * @return
     */
    public static String randomNumber(int length) {
        return randomString(NUMBER, length);
    }

    /**
     * 获取随机字符串
     *
     * @param sampleString 样本字符串
     * @param length       生成的随机字符串长度
     * @return 返回随机字符串
     */
    public static String randomString(String sampleString, int length) {
        if (sampleString == null || sampleString.length() == 0) {
            return "";
        }
        if (length < 1) {
            length = 1;
        }
        final StringBuilder sb = new StringBuilder(length);
        int baseLength = sampleString.length();
        while (sb.length() < length) {
            int number = ThreadLocalRandom.current().nextInt(baseLength);
            sb.append(sampleString.charAt(number));
        }
        return sb.toString();
    }

    public static String genUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}