/**
 * @(#)ChangeStateEnum.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */
public enum ChangeStatusEnum {
    IN(1, "进行中"),
    CANCEL(2, "取消完结"),
    DELAY(3, "延期"),
    END(4, "完结"),
    WAIT(5, "待发起"),
    
    WAIT_SUBMIT_CHANGE_APPLY(6, "待提交变更申请"),
    WAIT_CONFIRM_CHANGE_PLAN(7, "待确认变更方案"),
    WAIT_DEPT_LEADER_APPROVE(8, "待部门负责人审批"),
    WAIT_CHANGE_ADMIN_APPROVE(9, "待变更管理员审批"),
    WAIT_QUALITY_LEADER_APPROVE(10, "待质量部负责人审批"),
    WAIT_EXEC_CHANGE_PLAN(11, "待执行变更方案"),
    WAIT_CONFIRM_EXEC_RESULT(12, "待确认执行结果"),
    FINISHED(13, "已完结"),
    CANCELLED(14, "已取消");

    private Integer status;

    private String desc;

    ChangeStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据状态码获取描述
     * @param status 状态码
     * @return 状态描述
     */
    public static String getDescByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return Arrays.stream(ChangeStatusEnum.values())
                .filter(e -> Objects.equals(e.getStatus(), status))
                .map(ChangeStatusEnum::getDesc)
                .findFirst()
                .orElse(null);
    }
}