package com.netease.mail.yanxuan.change.integration.item.meta;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
public class SpuTO {

    //商品ID
    private long id;

    //商品名
    private String name;

    //商品销售标题
    private String nickName;

    // itemType  http://yx.mail.netease.com/wiki#/doc/791608
    private int itemType;

    //商品状态 0,1:未上架 2:已上架 4:预上架
    private int status;

    //主skuId
    private long primarySkuId;

    //商品零售价，如果商品未设置主SKU，售价为null
    private BigDecimal retailPrice;

    //商品描述
    private String simpleDesc;

    //上架时间
    private long onSaleTime;

    //更新时间
    private long updateTime;

    //款式信息，X件装可选
    private int pieceNum;

    //pieceNum的单位描述
    private String pieceUnitDesc;

    //款式信息，X色可选
    private int colorNum;

    //产地
    private String productPlace;

    //商品中心发布状态：0：草稿;1:未发布 2:已发布(仅在已发布情况下各渠道可以进行售卖)3:作废
    private int icStatus;

    //商品多媒体信息
    private MultiMediaDetailTO mediaDetail;

    //SPU详情信息
    private SpuDetailTO detail;

    //SPU关联的SKU列表
    private List<SkuTo> skuList;

    //SPU关联的规格信息列表
    private List<SkuSpecTO> specList;

    //商品常见问题列表
    private List<SpuIssueTO> issueList;

    //标签列表（当前仅有制造商标签）
    private List<TagTO> tagList;

    //服务政策列表
    private List<PolicyTO> policyList;

    //SPU属性集合,值范围和内容
    private Map<String, String> propertyMap;
}
