/**
 * @(#)ChangeFlowController.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.web.controller;

import com.netease.mail.yanxuan.change.biz.biz.ChangeSubFlowBiz;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeSubFlowCreateReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */
@Slf4j
@RestController
@RequestMapping("/change/sub/flow")
public class ChangeSubFlowController {

    @Autowired
    private ChangeSubFlowBiz changeSubFlowBiz;

    /**
     * 发起变更执行工单
     *
     * @return
     */
    @PostMapping("/create")
    public AjaxResult<String> createAndSubmit(@RequestBody @Valid ChangeSubFlowCreateReq changeSubFlowCreateReq) {
        return AjaxResult.success(changeSubFlowBiz.createAndSubmit(changeSubFlowCreateReq));
    }

}
