/**
 * @(#)ChangeFlowVO.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.vo;

import java.util.List;

import lombok.Builder;
import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */

@Builder
@Data
public class ChangeFlowVO {

    private Long id;

    /**
     * 工单id
     */
    private Long flowId;
    /**
     * 变更主体
     * com.netease.mail.yanxuan.change.biz.meta.enums.ChangeSubjectEnum
     */
    private Integer changeSubject;
    /**
     * 变更类型，一级类型>二级类型
     */
    private String changeType;
    /**
     * 变更内容
     */
    private String changeContent;
    /**
     * 变更负责人
     */
    private String changeCommander;
    /**
     * 变更商品列表
     */
    private List<ChangeItemVO> changeItems;
    /**
     * 变更供应商
     */
    private String supplier;
    /**
     * 变更状态
     * com.netease.mail.yanxuan.change.biz.meta.enums.ChangeStatusEnum
     */
    private Integer changeState;
    /**
     * 变更发起人
     */
    private String changeCreator;
    /**
     * 变更行动部门
     */
    private String changeExecDepartment;
    /**
     * 创建时间
     */
    private Long createTime;
}