package com.netease.mail.yanxuan.change.integration.email.service.impl;

import com.netease.mail.yanxuan.change.integration.email.email.EmailFactor;
import com.netease.mail.yanxuan.change.integration.email.enums.EmailTemplateEnum;
import com.netease.mail.yanxuan.change.integration.email.service.IEmailService;
import com.netease.mail.yanxuan.change.integration.email.enums.EmailParamEnum;
import com.netease.mail.yanxuan.change.integration.email.service.UasClientService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class EmailServiceImpl implements IEmailService {

    @Autowired
    private UasClientService uasClient;

    @Autowired
    private EmailTemplateServiceImpl emailTemplateService;

    Logger logger = LoggerFactory.getLogger(EmailServiceImpl.class);

    @Override
    @Async("asyncEmail")
    public void sendEmail(Collection<String> toList, Collection<String> ccList,
                          EmailFactor factor,List<String>subjectParams) {
        if (factor != null) {
            String content = this.content(factor);
            if (!CollectionUtils.isEmpty(toList)) {
                toList = toList.stream().filter(e -> e != null).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty(ccList)) {
                ccList = ccList.stream().filter(e -> e != null).collect(Collectors.toList());
            }
            String subject = factor.getSubject();
            //标题参数处理
            if (subjectParams != null || subjectParams.size() != 0){
                subject = String.format(subject,subjectParams.toArray());
            }
            uasClient.sendEmail(subject, content, toList, ccList, null);
        }
    }


    /**
     * 根据邮件模版获取邮件内容
     *
     * @param emailFactor
     * @return
     */

    public String content(EmailFactor emailFactor) {
        EmailTemplateEnum emailTemplateEnum = emailFactor.getEmailTemplateEnum();
        return emailTemplateService.template(emailTemplateEnum.getCode(), emailFactor.getData(),
                emailFactor.getType());
    }

}

