package com.netease.mail.yanxuan.change.integration.email.enums;

public enum EmailTemplateEnum {


    /**
     * 异常问题跟进工单邮件
     */

    YX_QC_RELEASE_FLOW("yxqc_release_flow","品控发起工单", "【ECR异常工单新建】 %s，请判定异常等级和制定临时措施"),

    YX_QC_CHANGE_RELEASE_FLOW("yxqc_change_release_flow","发起变更","【待处理】%s 变更申请提交 "),

    YX_QC_CHANGE_SUBMIT_CANCEL("yx_qc_change_submit_cancel","变更取消","%s 变更取消通知"),

    YX_QC_CHANGE_SUBMIT_FORWARD("yx_qc_change_submit_forward","变更转交","%s 变更工单转交通知"),

    YX_QC_CHANGE_EXECUTE("yx_qc_change_execute","变更执行","【待处理】变更行动项确认 %s"),

    YX_QC_CHANGE_AFFIRM("yx_qc_change_affirm","变更确认","【待处理】变更结果确认 %s"),

    YX_QC_CHANGE_FINISH("yx_qc_change_finish","工单完结","【已完结】%s 变更风险行动项已完结，请开始执行变更。"),

    YX_QC_CHANGE_PENDING("yx_qc_change_pending","待处理","【待处理】执行标准号 执行标准名称已变更 请排查对应的商品变更");
    /**
     * 模版code
     */
    private String code;

    /**
     * 模版名称
     */
    private String name;

    /**
     * 邮件标题format
     */
    private String subject;

    EmailTemplateEnum(String code, String name, String subject){
        this.code = code;
        this.name = name;
        this.subject = subject;
    }

    public String getCode(){
        return code;
    }

    public String getSubject(){
        return subject;
    }

    public static EmailTemplateEnum getEmailTemplateEnum(String code){
        for (EmailTemplateEnum template : EmailTemplateEnum.values()) {
            if (template.getCode().equals(code)) {
                return template;
            }
        }
        return null;
    }

}
