package com.netease.mail.yanxuan.change.integration.email.enums;

public enum EmailEhcFlowEnum {
    /**
     * 异常任务工单邮件
     */
    YX_EHC_CREATE_TASK_SUBMIT("ehc_create_task_submit","创建临时/纠正措施/验证任务_提交", "【待处理】异常处理-%s 任务：%s 任务工单ID：%s",
            "你好，由%s 发起的异常问题任务工单：%s ，工单ID：%s，请尽快前往处理"),

    YX_EHC_CREATE_TASK_CANCEL("ehc_create_task_cancel","创建临时/纠正措施/验证任务_取消", "【已取消】异常处理-%s 任务：%s 任务工单ID：%s ",
            "你好，由%s 发起的异常问题任务工单：%s ，工单ID：%s ，已被 %s %s 操作取消，请前往查看详情"),

    YX_EHC_PROCESS_RESULT_CARE_OF("ehc_process_result_care_of","填写任务处理结果_转交", "【待处理】异常处理-%s 任务：%s 任务工单ID：%s ",
            "你好，由%s 发起的异常问题任务工单：%s，工单ID：XXX，现由 %s %s 转交给你，请尽快前往处理"),

    YX_EHC_PROCESS_RESULT_SUBMIT("ehc_process_result_submit","填写任务处理结果_提交", "【待审批】异常处理-%s 任务：%s 任务工单ID：%s",
            "你好，由%s 发起的异常问题任务工单：%s ，工单ID：XXX，由 %s %s 完成了问题处理，需要审批，请尽快前往处理"),

    YX_EHC_TASK_RELEASE_CARE_OF("ehc_task_release_care_of","任务工单发起人审批_转交", "【待审批】异常处理-%s 任务：%s 任务工单ID：%s ",
            "你好，由%s 发起的异常问题任务工单：%s，工单ID：XXX，由 %s %s 完成了问题处理，需要审批，现由 %s %s 转交给你，请尽快前往处理"),

    YX_EHC_TASK_RELEASE_CHECK_NOT_PASS("ehc_task_release_check_not_pass","任务工单发起人审批_不通过", "【被驳回】异常处理-%s 任务：%s 任务工单ID：%s",
            "你好，由%s 发起的异常问题任务工单：%s，工单ID：%s，被 %s %s 驳回，请尽快前往处理"),

    /**
     * 供应商惩罚工单邮件
     */
    YX_EHC_CREATE_SUPPLIER_TASK_SUBMIT("ehc_create_supplier_task_submit","创建供应商惩罚任务_提交", "【待处理】异常处理-供应商惩罚任务：%s 任务工单ID：%s ",
            "你好，由%s 发起的供应商惩罚任务工单：%s，工单ID：%s，请尽快前往处理"),

    YX_EHC_CREATE_SUPPLIER_TASK_CARE_OF("ehc_create_supplier_task_care_of","创建供应商惩罚任务_转交", "【待处理】异常处理-供应商惩罚任务：%s 任务工单ID：%s ",
            "你好，由%s 发起的供应商惩罚任务工单：%s，工单ID：%s，现由（%s %s）转交给你，请尽快前往处理"),

    YX_EHC_SUPPLIER_RESULT_SUBMIT("ehc_supplier_process_result_submit","采购回填供应商处理结果_提交", "【待审批】异常处理-供应商惩罚任务：%s 任务工单ID：%s ",
            "你好，由%s 发起的供应商惩罚任务工单：%s，工单ID：%s，由（%s %s）完成了问题处理，需要审批，请尽快前往处理"),

    YX_EHC_SUPPLIER_RELEASE_CHECK_CARE_OF("ehc_supplier_release_check_care_of","工单发起人审批节点_转交", "【待审批】异常处理-供应商惩罚任务：%s 任务工单ID：%s",
            "你好，由%s 发起的供应商惩罚任务工单：%s，工单ID：%s，由（%s %s）完成了问题处理，需要审批，现由（%s %s）转交给你，请尽快前往处理"),

    YX_EHC_SUPPLIER_RELEASE_CHECK_PASS_OVER("ehc_supplier_release_check_pass_over","工单发起人审批节点_审核通过", "【已完结】异常处理-供应商惩罚任务：%s 任务工单ID：%s ",
            "你好，由%s 发起的供应商惩罚任务工单：%s，工单ID：%s，已完成处理，请前往查看详情"),

    YX_EHC_SUPPLIER_RELEASE_CHECK_NOT_PASS_BUY("ehc_supplier_release_check_not_pass_buy","工单发起人审批节点_审核不通过", "【被驳回】异常处理-供应商惩罚任务：%s 任务工单ID：%s ",
            "你好，由%s 发起的供应商惩罚任务工单：%s，工单ID：%s，被（%s %s）驳回，请尽快前往处理"),

    YX_EHC_CREATE_SUPPLIER_CANCEL("ehc_create_supplier_cancel","创建供应商惩罚任务_取消", "【已取消】异常处理-供应商惩罚任务：%s 任务工单ID：%s ",
            "你好，由%s 发起的供应商惩罚任务工单：%s ，工单ID：%s ，已被 %s %s 操作取消，请前往查看详情"),


    /**
     * 批量事件工单邮件
     */
    YX_EHC_CREATE_EVENT_TASK_SUBMIT("ehc_create_event_task_submit","创建批量事件任务_提交","【待处理】异常处理-批量事件记录任务：%s 任务工单ID：%s ",""),

    YX_EHC_CREATE_EVENT_TASK_DELIVER("ehc_create_event_task_deliver","处理批量事件任务_转交","【待处理】异常处理-批量事件记录任务：%s 任务工单ID：%s ",""),

    YX_EHC_CREATE_EVENT_TASK_CANCEL("ehc_create_event_task_cancel","创建批量事件任务_取消","【已取消】异常处理-批量事件记录任务：%s 任务工单ID：%s",""),

    /**
     * 临期/过期工单邮件
     */
    YX_EHC_FLOW_OVER_TIME("ehc_flow_over_time","临期/过期工单监控","ECR异常临期及延期任务工单提醒",""),



    /********************************** 异常问题主工单邮件模板  **********************************/

    YX_EHC_ABNORMAL_PROCESS("ehc_abnormal_process_template","待处理人处理邮件（非驳回）", "【待处理】异常问题：%s 工单ID：%s",
        ""),

    YX_EHC_ABNORMAL_AUDIT("ehc_abnormal_audit_template","待审核人审核邮件", "【待审批】异常问题：%s 工单ID：%s",
        ""),

    YX_EHC_ABNORMAL_DELIVER_PROCESS("ehc_abnormal_deliver_process_template","待转交人处理邮件", "【待处理】异常问题：%s 工单ID：%s",
        ""),

    YX_EHC_ABNORMAL_DELIVER_AUDIT("ehc_abnormal_deliver_audit_template","待转交人审核邮件", "【待审批】异常问题：%s 工单ID：%s",
        ""),

    YX_EHC_ABNORMAL_REFUSE("ehc_abnormal_refuse_template","被驳回待处理邮件", "【被驳回】异常问题：%s 工单ID：%s",
        ""),

    YX_EHC_ABNORMAL_END("ehc_abnormal_end_template","已完结通知邮件", "【已完结】异常问题：%s 工单ID：%s",
        ""),

    ;

    /**
     * 模版code
     */
    private String code;

    /**
     * 模版名称
     */
    private String name;

    /**
     * 邮件标题format
     */
    private String subject;
    /**
     * 邮件内容
     */
    private String content;

    EmailEhcFlowEnum(String code, String name, String subject, String content) {
        this.code = code;
        this.name = name;
        this.subject = subject;
        this.content = content;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public String getSubject() {
        return subject;
    }

    public String getContent() {
        return content;
    }
}
