//package com.netease.mail.yanxuan.change.integration.email.util;
//
//import com.netease.mail.yanxuan.change.integration.email.exception.RpcConnectException;
//import com.netease.mail.yanxuan.change.integration.email.exception.RpcException;
//import com.netease.mail.yanxuan.change.integration.email.exception.RpcStatusException;
//import com.netease.mail.yanxuan.change.integration.email.exception.RpcTimeoutException;
//import org.apache.http.Consts;
//import org.apache.http.Header;
//import org.apache.http.HttpEntity;
//import org.apache.http.client.config.RequestConfig;
//import org.apache.http.client.entity.UrlEncodedFormEntity;
//import org.apache.http.client.methods.CloseableHttpResponse;
//import org.apache.http.client.methods.HttpGet;
//import org.apache.http.client.methods.HttpPost;
//import org.apache.http.client.methods.HttpRequestBase;
//import org.apache.http.config.*;
//import org.apache.http.conn.socket.ConnectionSocketFactory;
//import org.apache.http.conn.socket.PlainConnectionSocketFactory;
//import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
//import org.apache.http.entity.ContentType;
//import org.apache.http.entity.StringEntity;
//import org.apache.http.impl.client.CloseableHttpClient;
//import org.apache.http.impl.client.HttpClients;
//import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
//import org.apache.http.message.BasicHeader;
//import org.apache.http.message.BasicNameValuePair;
//import org.apache.http.ssl.SSLContexts;
//import org.apache.http.util.EntityUtils;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//
//import javax.net.ssl.SSLContext;
//import javax.net.ssl.TrustManager;
//import javax.net.ssl.X509TrustManager;
//import java.io.IOException;
//import java.io.UnsupportedEncodingException;
//import java.net.ConnectException;
//import java.net.SocketTimeoutException;
//import java.net.URI;
//import java.net.URLEncoder;
//import java.nio.charset.CodingErrorAction;
//import java.security.KeyManagementException;
//import java.security.NoSuchAlgorithmException;
//import java.security.cert.CertificateException;
//import java.security.cert.X509Certificate;
//import java.util.HashMap;
//import java.util.List;
//import java.util.Map;
//import java.util.stream.Collectors;
//
///**
// * HttpClient 封装
// *
// * @author lwtang
// * @date 2019-02-19
// */
//public class HttpClientUtil {
//
//    private static final Logger LOG = LoggerFactory.getLogger(HttpClientUtil.class);
//
//    private static final int DEFAULT_TIME_OUT = 5000;
//
//    private static final String DEFAULT_ENCODING = "UTF-8";
//
//    private static PoolingHttpClientConnectionManager connManager = null;
//
//    private static CloseableHttpClient httpclient = null;
//
//
//    static {
//        try {
//            SSLContext sslContext = SSLContexts.custom().build();
//            sslContext.init(null, new TrustManager[] { new DefaultTrustManager() }, null);
//
//            Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder
//                    .<ConnectionSocketFactory>create()
//                    .register("http", PlainConnectionSocketFactory.INSTANCE)
//                    .register("https", new SSLConnectionSocketFactory(sslContext)).build();
//
//            connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
//            httpclient = HttpClients.custom().setConnectionManager(connManager).build();
//            // Create socket configuration
//            SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(true)
//                    .setSoReuseAddress(true).setSoTimeout(DEFAULT_TIME_OUT).setTcpNoDelay(true).build();
//            connManager.setDefaultSocketConfig(socketConfig);
//            // Create message constraints
//            MessageConstraints messageConstraints = MessageConstraints.custom()
//                    .setMaxHeaderCount(200).setMaxLineLength(2000).build();
//            // Create connection configuration
//            ConnectionConfig connectionConfig = ConnectionConfig.custom()
//                    .setMalformedInputAction(CodingErrorAction.IGNORE)
//                    .setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8)
//                    .setMessageConstraints(messageConstraints).build();
//            connManager.setDefaultConnectionConfig(connectionConfig);
//            connManager.setMaxTotal(300);
//            connManager.setDefaultMaxPerRoute(100);
//        } catch (KeyManagementException e) {
//            LOG.error("KeyManagementException", e);
//        } catch (NoSuchAlgorithmException e) {
//            LOG.error("NoSuchAlgorithmException", e);
//        }
//    }
//
//    public static String get(String url, Map<String, Object> params, Map<String, String> header,
//                             int timeout) {
//        return doGet(url, params, header, DEFAULT_ENCODING, timeout);
//    }
//
//    public static String doGet(String url, Map<String, Object> params, Map<String, String> header,
//                               String encoding, int timeout) {
//        String responseString = null;
//
//        HttpGet get = new HttpGet();
//        fillUrl(url, params, encoding, get);
//        fillHeader(header, get);
//        fillConfig(timeout, timeout, get);
//
//        try {
//            CloseableHttpResponse response = httpclient.execute(get);
//            try {
//                int resHttpCode = response.getStatusLine().getStatusCode();
//                if( resHttpCode != 200) {
//                    throw new RpcStatusException(resHttpCode, "status code " + resHttpCode + " not equal 200");
//                }
//                HttpEntity entity = response.getEntity();
//                try {
//                    if (entity != null) {
//                        responseString = EntityUtils.toString(entity, encoding);
//                    }
//                } finally {
//                    if (entity != null) {
//                        entity.getContent().close();
//                    }
//                }
//                return responseString;
//            } catch (Exception e) {
//                LOG.error("[HttpUtils Get response error]", e);
//                throw e;
//            } finally {
//                if (response != null) {
//                    response.close();
//                }
//            }
//        } catch (ConnectException e) {
//            throw new RpcConnectException("request connect failed!");
//        } catch (SocketTimeoutException e) {
//            throw new RpcTimeoutException("request timeout!");
//        } catch (IOException e) {
//            LOG.error("[query webservice error]", e);
//        } finally {
//            get.releaseConnection();
//        }
//        return responseString;
//    }
//
//
//
//    public static String postJson(String url, String params, int timeout) {
//        Map<String, String> header = new HashMap<>();
//        header.put("Content-type", ContentType.APPLICATION_JSON.getMimeType());
//        return doPost(url, new StringEntity(params, DEFAULT_ENCODING), header, DEFAULT_ENCODING,
//                timeout);
//    }
//
//
//    public static String post(String url, Map<String, Object> params, int timeout) {
//        Map<String, String> header = new HashMap<>();
//        header.put("Content-type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
//
//        HttpEntity httpEntity = null;
//        if (params != null && params.size() > 0) {
//            List<BasicNameValuePair> formParams = params.entrySet().stream()
//                    .map(entry -> new BasicNameValuePair(entry.getKey(),
//                            entry.getValue() == null ? "" : entry.getValue().toString()))
//                    .collect(Collectors.toList());
//
//            try {
//                httpEntity = new UrlEncodedFormEntity(formParams, DEFAULT_ENCODING);
//            } catch (UnsupportedEncodingException e) {
//                throw new RpcException(e);
//            }
//        }
//        return doPost(url, httpEntity, header, DEFAULT_ENCODING, timeout);
//    }
//
//
//    public static String doPost(String url, HttpEntity params, Map<String, String> header,
//                                String encoding, int timeout) {
//        String responseContent = null;
//
//        HttpPost post = new HttpPost(url);
//
//        fillHeader(header, post);
//        fillConfig(timeout, timeout, post);
//
//        post.setEntity(params);
//        try {
//            CloseableHttpResponse response = httpclient.execute(post);
//            try {
//                HttpEntity entity = response.getEntity();
//                responseContent = EntityUtils.toString(entity, encoding);
//            } finally {
//                if (response != null) {
//                    response.close();
//                }
//            }
//        } catch (ConnectException e) {
//            throw new RpcConnectException("request connect failed!");
//        } catch (SocketTimeoutException e) {
//            throw new RpcTimeoutException("request timeout!");
//        } catch (IOException e) {
//            LOG.error("[query webservice error]", e);
//        } finally {
//            post.releaseConnection();
//        }
//        return responseContent;
//    }
//
//    /**
//     * concat url
//     */
//    private static String fillUrl(String url, Map<String, Object> params, String encoding,
//                                  HttpRequestBase requestBase) {
//        StringBuilder sb = new StringBuilder();
//        sb.append(url);
//        int i = 0;
//        if (params != null && params.size() > 0) {
//            for (Map.Entry<String, Object> entry: params.entrySet()) {
//                if (i == 0 && !url.contains("?")) {
//                    sb.append("?");
//                } else {
//                    sb.append("&");
//                }
//                sb.append(entry.getKey());
//                sb.append("=");
//                Object v = entry.getValue();
//                String value = v == null ? "" : v.toString();
//                encoding = encoding == null ? Consts.UTF_8.name() : encoding;
//                try {
//                    sb.append(URLEncoder.encode(value, encoding));
//                } catch (UnsupportedEncodingException e) {
//                    LOG.warn("encoding common get params error, value={}", value, e);
//                    try {
//                        sb.append(URLEncoder.encode(value, encoding));
//                    } catch (Exception ex) {
//                        e.printStackTrace();
//                    }
//                }
//                i++;
//            }
//        }
//        requestBase.setURI(URI.create(sb.toString()));
//        return sb.toString();
//    }
//
//
//    private static void fillHeader(Map<String, String> header, HttpRequestBase requestBase) {
//        if (header == null || header.size() == 0) {
//            return;
//        }
//
//        Header[] headers = header.entrySet().stream()
//                .map(entry -> new BasicHeader(entry.getKey(), entry.getValue()))
//                .collect(Collectors.toList()).toArray(new Header[header.size()]);
//
//        if (headers.length > 0) {
//            requestBase.setHeaders(headers);
//        }
//    }
//
//
//    /**
//     * fill common conf
//     */
//    private static void fillConfig(int connectTimeout, int soTimeout, HttpRequestBase requestBase) {
//        if (connectTimeout <= 0) {
//            connectTimeout = DEFAULT_TIME_OUT;
//        }
//        if (soTimeout <= 0) {
//            soTimeout = DEFAULT_TIME_OUT;
//        }
//
//        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(soTimeout)
//                .setConnectTimeout(connectTimeout).setConnectionRequestTimeout(connectTimeout).build();
//        requestBase.setConfig(requestConfig);
//    }
//
//
//    public static class DefaultTrustManager implements X509TrustManager {
//
//        @Override
//        public void checkClientTrusted(X509Certificate[] x509Certificates, String s)
//                throws CertificateException {}
//
//        @Override
//        public void checkServerTrusted(X509Certificate[] x509Certificates, String s)
//                throws CertificateException {}
//
//        @Override
//        public X509Certificate[] getAcceptedIssuers() {
//            return new X509Certificate[0];
//        }
//    }
//
//}
