package com.netease.mail.yanxuan.change.assembly;

import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import com.netease.yanxuan.missa.client.annotation.EnableMissaClients;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.PropertySource;

import tk.mybatis.spring.annotation.MapperScan;

/**
 * 项目启动类
 */
@ComponentScan(basePackages = {"com.netease.mail.yanxuan.change","com.netease.mail.yanxuan.qc"})
@MapperScan("com.netease.mail.yanxuan.change.dal.mapper")
@EnableApolloConfig
@EnableMissaClients(basePackages = "com.netease.mail.yanxuan.change")
@SpringBootApplication
@ImportResource(locations = { "classpath:applicationContext-service-client-base.xml" })
@PropertySource(value = {
        "classpath:${spring.profiles.active}/service.properties", }, encoding = "UTF-8", ignoreResourceNotFound = true)
public class Application extends SpringBootServletInitializer {

    public static void main(String[] args) throws Exception {
        SpringApplication.run(Application.class, args);
    }
}
