/**
 * @(#)ChangeFlowCancelReq.java, 2022/11/21.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.req;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/11/21
 */
@Data
public class ChangeFlowCancelReq {

    /**
     * 工单id
     */
    @NotNull(message = "工单id不能为空")
    private Long flowId;

    @NotBlank(message = "取消原因不能为空")
    @Size(max = 200, message = "取消原因限制200字")
    private String cancelReason;
    
    /**
     * 操作类型：CANCEL-取消，TERMINATION-终止
     * 默认值为 CANCEL，保持向后兼容
     */
    private String type = "CANCEL";
}