/**
 * @(#)ChangeExecRecordMapper.java, 2022/11/11.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import com.netease.mail.yanxuan.change.dal.entity.ChangeExecRecord;

/**
 * @Author zcwang
 * @Date 2022/11/11
 */
@Mapper
public interface ChangeExecRecordMapper extends tk.mybatis.mapper.common.Mapper<ChangeExecRecord> {


    @Select("SELECT * FROM TB_YX_QC_CHANGE_EXEC_RECORD WHERE change_record_id = #{changeRecordId}")
    List<ChangeExecRecord> selectByChangeRecordId(@Param("changeRecordId") Long id);

    @Insert({ "<script>",
        "insert into TB_YX_QC_CHANGE_EXEC_RECORD(change_record_id, change_exec_department, change_exec_user_type, change_exec_user, change_exec_user_email, change_risk_desc, change_exec_project, change_checking, change_exec_finish_time, change_exec_finish_desc, sub_flow_id, sub_flow_record_id, create_time, update_time) values ",
        "<foreach collection='list' item='item' index='index' separator=','>",
        "(#{item.changeRecordId}, #{item.changeExecDepartment}, #{item.changeExecUserType}, #{item.changeExecUser}, #{item.changeExecUserEmail}, #{item.changeRiskDesc}, #{item.changeExecProject}, #{item.changeChecking}, #{item.changeExecFinishTime}, #{item.changeExecFinishDesc}, #{item.subFlowId}, #{item.subFlowRecordId}, #{item.createTime}, #{item.updateTime})",
        "</foreach>", "</script>" })
    void insertList(@Param("list") List<ChangeExecRecord> changeExecRecordList);

    @Delete("delete from TB_YX_QC_CHANGE_EXEC_RECORD where change_record_id = #{changeRecordId}")
    Integer deleteByBaseId(@Param("changeRecordId") Long changeRecordId);

    /**
     * 根据变更行动工单记录ID删除行动项
     * @param subFlowRecordId 变更行动工单记录ID
     * @return 删除的记录数
     */
    @Delete("delete from TB_YX_QC_CHANGE_EXEC_RECORD where sub_flow_record_id = #{subFlowRecordId}")
    Integer deleteBySubFlowRecordId(@Param("subFlowRecordId") Long subFlowRecordId);

    @Select("SELECT DISTINCT(change_record_id) FROM TB_YX_QC_CHANGE_EXEC_RECORD WHERE change_exec_user_email LIKE #{changeExecUser}")
    List<Long> queryByUser(@Param("changeExecUser") String changeExecUser);

    @Select("SELECT * FROM TB_YX_QC_CHANGE_EXEC_RECORD ORDER BY id DESC LIMIT #{limit},#{offset}")
    List<ChangeExecRecord> queryList(@Param("limit") int limit, @Param("offset") Integer offset);

    /**
     * 根据变更行动工单记录ID查询行动项列表
     * @param subFlowRecordId 变更行动工单记录ID
     * @return 行动项列表
     */
    @Select("SELECT * FROM TB_YX_QC_CHANGE_EXEC_RECORD WHERE sub_flow_record_id = #{subFlowRecordId}")
    List<ChangeExecRecord> selectBySubFlowRecordId(@Param("subFlowRecordId") Long subFlowRecordId);

    /**
     * 批量根据变更行动工单记录ID列表查询行动项列表
     * @param subFlowRecordIds 变更行动工单记录ID列表
     * @return 行动项列表
     */
    @Select("<script>" +
            "SELECT * FROM TB_YX_QC_CHANGE_EXEC_RECORD WHERE sub_flow_record_id IN " +
            "<foreach collection='subFlowRecordIds' item='id' open='(' separator=',' close=')'>" +
            "#{id}" +
            "</foreach>" +
            "</script>")
    List<ChangeExecRecord> selectBySubFlowRecordIds(@Param("subFlowRecordIds") List<Long> subFlowRecordIds);

    /**
     * 根据变更行动人和部门查询变更行动工单记录ID列表（合并查询）
     * @param changeExecUser 变更行动人（邮箱），可为空
     * @param changeExecDepartment 变更行动部门，可为空
     * @return 变更行动工单记录ID列表
     */
    @Select({
            "<script>",
            "SELECT DISTINCT(sub_flow_record_id) FROM TB_YX_QC_CHANGE_EXEC_RECORD",
            "WHERE sub_flow_record_id IS NOT NULL",
            "<if test='changeExecUser != null'>",
            "AND change_exec_user_email LIKE #{changeExecUser}",
            "</if>",
            "<if test='changeExecDepartment != null'>",
            "AND change_exec_department LIKE CONCAT('%',#{changeExecDepartment},'%')",
            "</if>",
            "</script>"
    })
    List<Long> querySubFlowRecordIdsByExecCondition(@Param("changeExecUser") String changeExecUser, 
                                                     @Param("changeExecDepartment") String changeExecDepartment);
}
