/**
 * @(#)QCService.java, 2022/12/2.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service.rpc;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.integration.qc.QcRpcService;
import com.netease.mail.yanxuan.change.integration.qc.meta.QcCategoryVO;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2022/12/2
 */
@Slf4j
@Component
public class QCService {

    @Autowired
    private QcRpcService qcRpcService;
    
    public QcCategoryVO getQcCategoryListByItemId(Long itemId) {
        log.info("[QCService-getQcCategoryListByItemId] request of query={}", itemId);
        AjaxResult<QcCategoryVO> response = qcRpcService.getQcCategoryListByItemId(itemId);
        log.info("[QCService-getQcCategoryListByItemId] response of query QcCategoryList ={}",
            JSON.toJSONString(response));
        if (Boolean.TRUE.equals(response.isSuccess())) {
            return response.getData();
        }
        log.error("[op:rpc-getQcCategoryListByItemId] query QcCategoryList failed, query={}, errMsg={}", itemId,
            response.getMsg());
        return null;
    }
    }