/**
 * @(#)ChangeFlowExcelDTO.java, 2022/11/25.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.integration.excel;

import com.netease.mail.yanxuan.change.common.enums.ChangeStatusEnum;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

/**
 * @Author zcwang
 * @Date 2022/11/25
 */
@Data
public class ChangeFlowExcelDTO {
    /**
     * 主键id
     */
    @Excel(name = "变更ID")
    private Long id;

    /**
     * 变更主体
     * @see ChangeSubjectEnum
     */
    @Excel(name = "变更主体")
    private String changeSubject;
    /**
     * 变更类型，一级类型>二级类型
     */
    @Excel(name = "变更类型")
    private String changeType;

    /**
     * 变更负责部门名
     */
    @Excel(name = "变更负责部门名")
    private String changeDepartment;

    /**
     * 变更内容
     */
    @Excel(name = "变更内容")
    private String changeContent;
    /**
     * 变更负责人
     */
    @Excel(name = "变更负责人")
    private String changeCommander;

    /**
     * 变更商品列表，SPUID+商品名称
     */
    @Excel(name = "变更商品")
    private String changeItems;
    /**
     * 变更供应商，仅展示供应商ID，没有时展示为“/”
     */
    @Excel(name = "变更供应商")
    private String supplier;
    /**
     * 变更状态
     * @see ChangeStatusEnum
     */
    @Excel(name = "变更状态")
    private Integer changeState;
    /**
     * 变更发起人
     */
    @Excel(name = "变更发起人")
    private String changeCreator;

    /**
     * 变更行动部门列表
     */
    @Excel(name = "变更行动部门")
    private String execDepartmentStrList;
    /**
     * 创建时间
     */
    @Excel(name = "创建时间")
    private Long createTime;

}