package com.netease.mail.yanxuan.change.integration.rpc;

import java.io.IOException;
import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

/**
 * @author jmt
 * @Date 2021/6/7
 */
public class RpcListData<T> implements RpcTemplate.CallHandler<List<T>> {
    private final Class<T> tClass;

    public RpcListData(Class<T> tClass) {
        this.tClass = tClass;
    }

    @Override
    public List<T> handle(String resp) throws IOException {
        JSONObject rpcResult = JSON.parseObject(resp);
        int code = rpcResult.getIntValue(RpcConst.CODE);
        if (code == RpcCode.OK.getValue()) {
            return JSON.parseArray(rpcResult.getString(RpcConst.DATA), tClass);
        }
        throw new RpcResultException("response error, code = " + code);
    }
}
