/**
 * @(#)CreateParamVO.java, 2022/11/28.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.integration.todo;

import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author zcwang
 * @Date 2022/11/28
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class TaskCreateParamVO {

    /**
     * 业务key
     */
    private String businessKey;
    /**
     * 任务详情数据
     */
    private String content;
    /**
     * 产品号
     */
    private String product;
    /**
     * 任务创建人
     */
    private String taskCreator;
    /**
     * 任务处理人
     */
    private String taskHandler;
    /**
     * 任务处理人集合
     */
    private List<UserInfo> taskHandlerList;
    /**
     * 单个任务处理人场景
     */
    private String taskHandlerName;
    /**
     * 任务标题
     */
    private String taskTitle;
    /**
     * 已废弃
     */
    @Deprecated
    private Integer taskTypeId;
    /**
     * 任务类型key
     */
    private String taskTypeKey;
}