package com.netease.mail.yanxuan.change.web.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author zhangbingQAQ
 * @date 2021/8/27 10:18
 */
@Configuration
public class WebMvcConfig implements WebMvcConfigurer {

    @Autowired
    private UserInterceptor userInterceptor;

    @Autowired
    private AdminUserLoginInterceptor adminUserLoginInterceptor;

    /**`
     * 拦截器配置
     *
     * @param registry
     */
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(userInterceptor).addPathPatterns("/**").excludePathPatterns("/i/health")
            .excludePathPatterns("/change/flow/getOperator", "/test/**", "/api/des/callback/**");
        registry.addInterceptor(adminUserLoginInterceptor).addPathPatterns("test/**");
    }

}
