/**
 * @(#)ChangeSubFlowOwnershipVO.java, 2024/12/04.
 * <p/>
 * Copyright 2024 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 子单归属关系（用于标识当前用户与子单的归属关系）
 * 对应查询条件：
 * 1. 变更行动人/行动项审批人=当前用户（change_exec_user_email = 当前用户 OR approver 包含当前用户）
 * 2. 变更负责人=当前用户的变更工单所关联的全部变更行动工单（change_commander = 当前用户）
 * 
 * @Author system
 * @Date 2024/12/04
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ChangeSubFlowOwnershipVO {

    /**
     * 是否是执行人（change_exec_user_email）
     */
    private Boolean isExecutor;

    /**
     * 是否是审批人（approver）
     */
    private Boolean isApprover;

    /**
     * 是否是主单变更负责人（change_commander，关联主单的负责人）
     */
    private Boolean isMainFlowCommander;
}

