/**
 * @(#)BuildAndSendEmailImpl.java, 2023/2/7.
 * <p/>
 * Copyright 2023 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.biz.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import com.netease.mail.yanxuan.change.biz.biz.DepartmentLeaderBiz;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.netease.mail.yanxuan.change.biz.biz.ChangeFlowBiz;
import com.netease.mail.yanxuan.change.biz.config.AppConfig;
import com.netease.mail.yanxuan.change.biz.service.BuildAndSendEmail;
import com.netease.mail.yanxuan.change.biz.service.ChangeFlowExecService;
import com.netease.mail.yanxuan.change.biz.service.change.ChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.rpc.IusService;
import com.netease.mail.yanxuan.change.biz.service.rpc.SupplierSendService;
import com.netease.mail.yanxuan.change.common.enums.ChangeSubjectEnum;
import com.netease.mail.yanxuan.change.common.enums.CreateSourceEnum;
import com.netease.mail.yanxuan.change.dal.entity.ChangeExecRecord;
import com.netease.mail.yanxuan.change.dal.entity.ChangeRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeConfigPo;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeFlowCreateReq;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeFlowExecVO;
import com.netease.mail.yanxuan.change.integration.email.enums.EmailTemplateEnum;
import com.netease.mail.yanxuan.change.integration.flow.UserQueryDTO;
import com.netease.mail.yanxuan.change.integration.flow.ius.rsp.IusUserInfoRsp;
import com.netease.mail.yanxuan.change.integration.todo.ChangeExecuteEmailDTO;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author zcwang
 * @Date 2023/2/7
 */
@Service
@Slf4j
public class BuildAndSendEmailImpl implements BuildAndSendEmail {

    @Autowired
    private IusService iusService;

    @Autowired
    private ChangeFlowExecService changeFlowExecService;

    @Autowired
    private ChangeFlowBiz changeFlowBiz;

    @Autowired
    private AppConfig appConfig;

    @Autowired
    private SupplierSendService sendSupplierEmail;

    @Autowired
    private ChangeConfigService changeConfigService;

    @Autowired
    private DepartmentLeaderBiz departmentLeaderBiz;

    @Override
    @Async("asyncBuild")
    public void buildAndSendEmailCreate(ChangeRecord changeRecord, List<ChangeExecRecord> changeExecRecords, StringBuilder changeType, String changeCommander, ChangeFlowCreateReq changeFlowCreateReq) {
        HashMap<String, Object> param = new HashMap<>();
        param.put("changeId", changeRecord.getFlowId());
        param.put("changeSubject", ChangeSubjectEnum.getChangeSubjectEnum(changeRecord.getChangeSubject()).getDesc());
        param.put("changeContent", changeRecord.getChangeContent());
        param.put("changeReason", changeRecord.getChangeReason());
        IusUserInfoRsp user = iusService.queryUserInfo(changeRecord.getChangeCommander());
        param.put("changeCommander", user == null ? changeRecord.getChangeCommander() : user.getName());
        param.put("changeCommanderEmail", changeRecord.getChangeCommander());
        param.put("flowUrl", changeRecord.getFlowId());
        List<ChangeExecuteEmailDTO> dataList = new ArrayList<>();
        changeExecRecords.forEach(i -> {
            ChangeExecuteEmailDTO changeExecuteEmailDTO = new ChangeExecuteEmailDTO();
            changeExecuteEmailDTO.setChangeExecDepartment(i.getChangeExecDepartment());
            changeExecuteEmailDTO.setChangeExecUser(i.getChangeExecUserEmail());
            changeExecuteEmailDTO.setChangeRiskDesc(i.getChangeRiskDesc());
            changeExecuteEmailDTO.setChangeExecProject(i.getChangeExecProject());
            changeExecuteEmailDTO.setChangeChecking(i.getChangeChecking());
            dataList.add(changeExecuteEmailDTO);
        });
        // 邮件附件执行人改为名字+邮箱格式，没有的话兜底邮箱
        List<String> changeExecUserList = dataList.stream().map(ChangeExecuteEmailDTO::getChangeExecUser).collect(Collectors.toList());
        List<IusUserInfoRsp> iusUserInfoRsps = iusService.queryUserListInfo(UserQueryDTO.builder().uids(changeExecUserList).build());

        dataList.forEach(d -> {
            Optional<IusUserInfoRsp> anyExeUser = iusUserInfoRsps.stream().filter(ius -> ius.getUid().equals(d.getChangeExecUser())).findAny();
            String execUserName;
            if (anyExeUser.isPresent()) {
                execUserName = anyExeUser.get().getName();
            } else {
                // 批量查询没查到的人名，通过全量查询单独再查一次
                IusUserInfoRsp iusUserInfo = iusService.queryUserInfo(d.getChangeExecUser());
                execUserName = iusUserInfo == null || StringUtils.isBlank(user.getName()) ? "" : user.getName();
            }
            d.setChangeExecUser(execUserName + d.getChangeExecUser());
        });
        log.debug("[buildAndSendEmailCreate] changeExecUserList:{}, dataList:{}", JSON.toJSONString(changeExecUserList),
            JSON.toJSONString(dataList));
        param.put("dataList", dataList);
        String subjectParam = ChangeSubjectEnum.getChangeSubjectEnum(changeRecord.getChangeSubject()).getDesc() + changeType
                + changeRecord.getFlowId().toString();

        List<ChangeFlowExecVO> changeFlowExecRecord = changeFlowExecService
                .getChangeFlowExecRecord(changeRecord.getId());
        List<String> execUserEmailList = changeFlowExecRecord.stream().map(ChangeFlowExecVO::getChangeExecUserEmail)
                .collect(Collectors.toList());
        // 获取指定人的上级部门主管邮箱
        List<String> ccList = departmentLeaderBiz.getDepartmentLeaders(execUserEmailList);
        // 变更执行，抄送：所有变更行动人上一级LEADER，变更负责人、变更转交人（如有）
        ccList.add(changeCommander);
        // 变更执行，收件人：所有变更行动人+变更管理QM（cuiyixian@corp.netease.com）
        execUserEmailList.add(appConfig.getChangeManageQM());
        changeFlowBiz.qcSendEmail(execUserEmailList, ccList, subjectParam, EmailTemplateEnum.YX_QC_CHANGE_EXECUTE, param);
        // 如果是供应商，再次发送供应商邮件
        if (changeFlowCreateReq.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())) {
            sendSupplierEmail.sendSupplierEmail(changeRecord.getCreateSupplier(), subjectParam,
                    EmailTemplateEnum.YX_QC_CHANGE_EXECUTE, param);
        }
        // 如果是其他端发起但是是供应商变更，再次发送供应商邮件
        if (!changeFlowCreateReq.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())
                && ChangeSubjectEnum.SUPPLIER.getType().equals(changeRecord.getChangeSubject())) {
            sendSupplierEmail.sendSupplierEmail(changeRecord.getChangeSupplier(), subjectParam,
                    EmailTemplateEnum.YX_QC_CHANGE_EXECUTE, param);
        }
    }

    @Override
    @Async("asyncBuild")
    public void buildAndSendEmailSubmit(ChangeRecord changeRecord, List<ChangeExecRecord> changeExecRecords) {
        HashMap<String, Object> param = new HashMap<>();
        param.put("changeId", changeRecord.getFlowId());
        param.put("changeSubject", ChangeSubjectEnum.getChangeSubjectEnum(changeRecord.getChangeSubject()).getDesc());
        param.put("changeContent", changeRecord.getChangeContent());
        param.put("changeReason", changeRecord.getChangeReason());
        IusUserInfoRsp user = iusService.queryUserInfo(changeRecord.getChangeCommander());
        param.put("changeCommander", user == null ? changeRecord.getChangeCommander() : user.getName());
        param.put("changeCommanderEmail", changeRecord.getChangeCommander());
        param.put("flowUrl", changeRecord.getFlowId());
        List<ChangeExecuteEmailDTO> dataList = new ArrayList<>();
        changeExecRecords.forEach(i -> {
            ChangeExecuteEmailDTO changeExecuteEmailDTO = new ChangeExecuteEmailDTO();
            changeExecuteEmailDTO.setChangeExecDepartment(i.getChangeExecDepartment());
            changeExecuteEmailDTO.setChangeExecUser(i.getChangeExecUserEmail());
            changeExecuteEmailDTO.setChangeRiskDesc(i.getChangeRiskDesc());
            changeExecuteEmailDTO.setChangeExecProject(i.getChangeExecProject());
            changeExecuteEmailDTO.setChangeChecking(i.getChangeChecking());
            dataList.add(changeExecuteEmailDTO);
        });
        // 邮件附件执行人改为名字+邮箱格式，没有的话兜底邮箱
        List<String> changeExecUserList = dataList.stream().map(ChangeExecuteEmailDTO::getChangeExecUser).collect(Collectors.toList());
        List<IusUserInfoRsp> iusUserInfoRsps = iusService.queryUserListInfo(UserQueryDTO.builder().uids(changeExecUserList).build());

        dataList.forEach(d -> {
            Optional<IusUserInfoRsp> anyExeUser = iusUserInfoRsps.stream().filter(ius -> ius.getUid().equals(d.getChangeExecUser())).findAny();
            String execUserName;
            if (anyExeUser.isPresent()) {
                execUserName = anyExeUser.get().getName();
            } else {
                // 批量查询没查到的人名，通过全量查询单独再查一次
                IusUserInfoRsp iusUserInfo = iusService.queryUserInfo(d.getChangeExecUser());
                execUserName = iusUserInfo == null || StringUtils.isBlank(user.getName()) ? "" : user.getName();
            }
            d.setChangeExecUser(execUserName + d.getChangeExecUser());
        });
        log.debug("[buildAndSendEmailSubmit] changeExecUserList:{}, dataList:{}", JSON.toJSONString(changeExecUserList),
                JSON.toJSONString(dataList));
        param.put("dataList", dataList);
        ChangeConfigPo changeConfigPoV1 = changeConfigService.queryInfoPo(changeRecord.getParentChangeClassId(), changeRecord.getSonChangeClassId());
        StringBuilder changeTypeV1 = new StringBuilder();
        try {
            changeTypeV1.append(changeConfigPoV1.getChangeTypes().get(0).getTypeName());
            changeTypeV1.append(changeConfigPoV1.getChangeTypes().get(1).getTypeName());
        } catch (Exception e) {
            log.error("queryInfoPo error:{}", JSON.toJSONString(changeConfigPoV1));
        }
        String subjectParam = ChangeSubjectEnum.getChangeSubjectEnum(changeRecord.getChangeSubject()).getDesc() + changeTypeV1
                + changeRecord.getFlowId().toString();
        // 负责人
        String changeCommander = changeRecord.getChangeCommander();
        List<ChangeFlowExecVO> changeFlowExecRecord = changeFlowExecService
                .getChangeFlowExecRecord(changeRecord.getId());
        List<String> execUserEmailList = changeFlowExecRecord.stream().map(ChangeFlowExecVO::getChangeExecUserEmail)
                .collect(Collectors.toList());
        // 获取指定人的上级部门主管邮箱
        List<String> ccList = departmentLeaderBiz.getDepartmentLeaders(execUserEmailList);
        // 变更执行，抄送：所有变更行动人上一级LEADER，变更负责人、变更转交人（如有）
        ccList.add(changeCommander);
        // 变更执行，收件人：所有变更行动人+变更管理QM（cuiyixian@corp.netease.com）
        execUserEmailList.add(appConfig.getChangeManageQM());
        changeFlowBiz.qcSendEmail(execUserEmailList, ccList, subjectParam,
                EmailTemplateEnum.YX_QC_CHANGE_EXECUTE, param);
        // 如果是供应商，再次发送供应商邮件
        if (changeRecord.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())) {
            sendSupplierEmail.sendSupplierEmail(changeRecord.getCreateSupplier(), subjectParam,
                    EmailTemplateEnum.YX_QC_CHANGE_EXECUTE, param);
        }
        // 如果是其他端发起但是是供应商变更，再次发送供应商邮件
        if (!changeRecord.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())
                && ChangeSubjectEnum.SUPPLIER.getType().equals(changeRecord.getChangeSubject())) {
            sendSupplierEmail.sendSupplierEmail(changeRecord.getChangeSupplier(), subjectParam,
                    EmailTemplateEnum.YX_QC_CHANGE_EXECUTE, param);
        }
    }

    @Override
    @Async("asyncBuild")
    public void sendConfirmResultFinishEmail(ChangeRecord changeRecord) {
        try {
            // 构建邮件参数（todo: 邮件内容参数待业务确认）
            HashMap<String, Object> finishMap = new HashMap<>();
            finishMap.put("changeId", changeRecord.getFlowId());
            finishMap.put("changeSubject", ChangeSubjectEnum.getChangeSubjectEnum(changeRecord.getChangeSubject()).getDesc());
            finishMap.put("changeContent", changeRecord.getChangeContent());
            IusUserInfoRsp user = iusService.queryUserInfo(changeRecord.getChangeCommander());
            finishMap.put("changeCommander", user == null ? changeRecord.getChangeCommander() : user.getName());
            // todo: 其他邮件内容参数待业务补充
            
            String finishSubjectParam = changeRecord.getFlowId().toString();
            
            // 收件人：变更负责人、变更行动人
            List<String> receiver = new ArrayList<>(Collections.singletonList(changeRecord.getChangeCommander()));
            List<ChangeFlowExecVO> execRecord = changeFlowExecService.getChangeFlowExecRecord(changeRecord.getId());
            List<String> userEmailList = execRecord.stream()
                    .map(ChangeFlowExecVO::getChangeExecUserEmail)
                    .filter(email -> StringUtils.isNotBlank(email))
                    .collect(Collectors.toList());
            receiver.addAll(userEmailList);
            
            // 抄送人：变更行动人上一级主管、变更管理QA群组
            userEmailList.addAll(receiver);
            List<String> ccList = departmentLeaderBiz.getDepartmentLeaders(userEmailList);
            ccList.add(appConfig.getChangeManageQM());
            
            // 发送邮件（todo: 邮件模板待业务确认）
            changeFlowBiz.qcSendEmail(receiver, ccList, finishSubjectParam, EmailTemplateEnum.YX_QC_CHANGE_FINISH, finishMap);
            
            // 如果是供应商变更，发送供应商邮件
            if (changeRecord.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())) {
                sendSupplierEmail.sendSupplierEmail(changeRecord.getCreateSupplier(), finishSubjectParam,
                        EmailTemplateEnum.YX_QC_CHANGE_FINISH, finishMap);
            }
            // 如果是其他端发起但是是供应商变更，发送供应商邮件
            if (!changeRecord.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())
                    && ChangeSubjectEnum.SUPPLIER.getType().equals(changeRecord.getChangeSubject())) {
                sendSupplierEmail.sendSupplierEmail(changeRecord.getChangeSupplier(), finishSubjectParam,
                        EmailTemplateEnum.YX_QC_CHANGE_FINISH, finishMap);
            }
            
            log.info("[sendConfirmResultFinishEmail] 确认变更结果完成邮件已发送，flowId:{}", changeRecord.getFlowId());
        } catch (Exception e) {
            log.error("[sendConfirmResultFinishEmail] 发送确认变更结果完成邮件失败，flowId:{}, error:{}", 
                    changeRecord.getFlowId(), e.getMessage(), e);
        }
    }

    @Override
    @Async("asyncBuild")
    public void sendConfirmResultCancelEmail(ChangeRecord changeRecord, String cancelReason) {
        try {
            // 构建邮件参数（todo: 邮件内容参数待业务确认）
            HashMap<String, Object> cancelMap = new HashMap<>();
            cancelMap.put("changeId", changeRecord.getFlowId());
            cancelMap.put("changeSubject", ChangeSubjectEnum.getChangeSubjectEnum(changeRecord.getChangeSubject()).getDesc());
            cancelMap.put("changeContent", changeRecord.getChangeContent());
            IusUserInfoRsp user = iusService.queryUserInfo(changeRecord.getChangeCommander());
            cancelMap.put("changeCommander", user == null ? changeRecord.getChangeCommander() : user.getName());
            cancelMap.put("cancelReason", cancelReason);
            // todo: 其他邮件内容参数待业务补充
            
            String cancelSubjectParam = changeRecord.getFlowId().toString();
            
            // 收件人：变更负责人、变更行动人
            List<String> receiver = new ArrayList<>(Collections.singletonList(changeRecord.getChangeCommander()));
            List<ChangeFlowExecVO> execRecord = changeFlowExecService.getChangeFlowExecRecord(changeRecord.getId());
            List<String> userEmailList = execRecord.stream()
                    .map(ChangeFlowExecVO::getChangeExecUserEmail)
                    .filter(email -> StringUtils.isNotBlank(email))
                    .collect(Collectors.toList());
            receiver.addAll(userEmailList);
            
            // 抄送人：变更行动人上一级主管、变更管理QA群组
            userEmailList.addAll(receiver);
            List<String> ccList = departmentLeaderBiz.getDepartmentLeaders(userEmailList);
            ccList.add(appConfig.getChangeManageQM());
            
            // 发送邮件（todo: 邮件模板待业务确认）
            changeFlowBiz.qcSendEmail(receiver, ccList, cancelSubjectParam, EmailTemplateEnum.YX_QC_CHANGE_SUBMIT_CANCEL, cancelMap);
            
            // 如果是供应商变更，发送供应商邮件
            if (changeRecord.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())) {
                sendSupplierEmail.sendSupplierEmail(changeRecord.getCreateSupplier(), cancelSubjectParam,
                        EmailTemplateEnum.YX_QC_CHANGE_SUBMIT_CANCEL, cancelMap);
            }
            // 如果是其他端发起但是是供应商变更，发送供应商邮件
            if (!changeRecord.getCreateSource().equals(CreateSourceEnum.TONG_ZHOU.getType())
                    && ChangeSubjectEnum.SUPPLIER.getType().equals(changeRecord.getChangeSubject())) {
                sendSupplierEmail.sendSupplierEmail(changeRecord.getChangeSupplier(), cancelSubjectParam,
                        EmailTemplateEnum.YX_QC_CHANGE_SUBMIT_CANCEL, cancelMap);
            }
            
            log.info("[sendConfirmResultCancelEmail] 确认变更结果取消邮件已发送，flowId:{}, cancelReason:{}", 
                    changeRecord.getFlowId(), cancelReason);
        } catch (Exception e) {
            log.error("[sendConfirmResultCancelEmail] 发送确认变更结果取消邮件失败，flowId:{}, error:{}", 
                    changeRecord.getFlowId(), e.getMessage(), e);
        }
    }
}