package com.netease.mail.yanxuan.change.dal.config;


import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.netease.yanxuan.pandora.DataSourceRefresher;
import com.netease.yanxuan.pandora.spring.annotation.EnableDataSourceRefresh;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.sql.DataSource;
import java.util.Set;

/**
 * @author hzfengyuexin@corp.netease.com
 */
@Configuration
@EnableTransactionManagement(proxyTargetClass = true)
@EnableApolloConfig("db-public")
@EnableDataSourceRefresh
public class DataSourceConfiguration {

    @Autowired
    private DrmDBConfig drmDBConfig;

    /**
     * pandora热切换数据源
     * */
    @Bean
    public DataSourceRefresher dataSourceRefresher() {
        DataSourceRefresher dataSourceRefresher = new DataSourceRefresher("db-public");
        Set<String> dataSource = ImmutableSet.of("db.url", "db.driverClassName", "db.username", "db.password");
        dataSourceRefresher.bindDataSourceWithPropertyKey("dataSource", dataSource);
        return dataSourceRefresher;
    }

    /**
     *db数据源
     */
    @Bean(name = "dataSource")
    @Primary
    public DataSource dataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setDriverClassName(drmDBConfig.getDriverClassName());
        dataSource.setUrl(drmDBConfig.getUrl());
        dataSource.setUsername(drmDBConfig.getUserName());
        dataSource.setPassword(drmDBConfig.getPassword());
        // 初始连接数
        dataSource.setInitialSize(1);
        // 最大连接数
        dataSource.setMaxActive(50);
        // 最小空闲连接数
        dataSource.setMinIdle(10);
        // 配置获取连接等待超时的时间
        dataSource.setMaxWait(60000);
        dataSource.setValidationQuery("SELECT 'x'");
        dataSource.setTestOnBorrow(true);
        dataSource.setTestOnReturn(false);
        dataSource.setTestWhileIdle(true);
        // 配置间隔多久才进行一次检测，检测需要关闭的空闲连接，单位是毫秒
        dataSource.setTimeBetweenEvictionRunsMillis(60000);
        dataSource.setMinEvictableIdleTimeMillis(300000);
        StatFilter filter = new StatFilter();
        filter.setSlowSqlMillis(5000);
        filter.setLogSlowSql(true);
        filter.setMergeSql(true);
        dataSource.setProxyFilters(Lists.newArrayList(filter));
        return dataSource;
    }

    @Bean("transactionManager")
    public DataSourceTransactionManager dataSourceTransactionManager(@Qualifier("dataSource") DataSource dataSource) {
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager();
        dataSourceTransactionManager.setDataSource(dataSource);
        return dataSourceTransactionManager;
    }

}
