/**
 * @(#)ChangeTypeMapper.java, 2022/11/11.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.mapper;

import com.netease.mail.yanxuan.change.dal.meta.model.po.ChangeTypePo;
import org.apache.ibatis.annotations.Mapper;
import com.netease.mail.yanxuan.change.dal.entity.ChangeType;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import java.util.List;

/**
 * @Author zcwang
 * @Date 2022/11/11
 */
@Mapper
public interface ChangeTypeMapper extends tk.mybatis.mapper.common.Mapper<ChangeType> {

    @Select("select * from TB_YX_QC_CHANGE_TYPE where type_name = #{typeName} and parent_id = 0 and delete_type  = 0")
    ChangeType queryTypeName(@Param("typeName") String typeName);


    @Select("select * from TB_YX_QC_CHANGE_TYPE where id in(#{id},#{sonChangeClassId}) and delete_type  = #{deleteType}  order by parent_id ")
    List<ChangeType> queryTypes(
            @Param("id") Long id,
            @Param("sonChangeClassId")Long sonChangeClassId,
            @Param("deleteType")Integer deleteType);

    @Select("select * from TB_YX_QC_CHANGE_TYPE where delete_type  = 0 ")
    List<ChangeTypePo> queryArrayChangeTypes();

    @Select("select * from TB_YX_QC_CHANGE_TYPE where parent_id = #{id} and delete_type  = 0")
    List<ChangeType> queryParent(@Param("id") Long id);

    /**
     * 批量根据ID列表查询变更类型
     * @param ids ID列表
     * @return 变更类型列表
     */
    @Select("<script>" +
            "SELECT * FROM TB_YX_QC_CHANGE_TYPE WHERE id IN " +
            "<foreach collection='ids' item='id' open='(' separator=',' close=')'>" +
            "#{id}" +
            "</foreach>" +
            " AND delete_type = 0" +
            "</script>")
    List<ChangeType> selectByIds(@Param("ids") List<Long> ids);

}