package com.netease.mail.yanxuan.change.integration.excel;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

/**
 * 变更配置导出DTO（一层保持原样，二层为行动项：变更行动项部门、变更行动人、变更风险描述、行动项、变更验证措施）
 */
@Data
public class ChangeConfigExcelDTO {
    
    @Excel(name = "配置ID")
    private Long id;
    
    @Excel(name = "变更主体")
    private String changeSubject;
    
    @Excel(name = "变更类型")
    private String changeType;
    
    @Excel(name = "变更等级")
    private String changeLevel;
    
    @Excel(name = "变更负责部门")
    private String changeDepartment;
    
    @Excel(name = "变更执行部门")
    private String participateChangeExecDepartment;
    
    @Excel(name = "变更负责人类型")
    private String changeCommanderType;
    
    @Excel(name = "变更负责人")
    private String changeCommander;
    
    @Excel(name = "是否需要资料")
    private String needFile;
    
    @Excel(name = "创建人")
    private String creator;
    
    @Excel(name = "创建时间")
    private String createTime;
    
    @Excel(name = "更新时间")
    private String updateTime;

    /** 二层：变更行动项部门 */
    @Excel(name = "变更行动项部门")
    private String changeExecDepartment;
    /** 二层：变更行动人 */
    @Excel(name = "变更行动人")
    private String changeExecUser;
    /** 二层：变更风险描述 */
    @Excel(name = "变更风险描述")
    private String changeRiskDesc;
    /** 二层：行动项 */
    @Excel(name = "行动项")
    private String changeExecProject;
    /** 二层：变更验证措施 */
    @Excel(name = "变更验证措施")
    private String changeChecking;
}

