package com.netease.mail.yanxuan.change.integration.excel;

import java.util.ArrayList;
import java.util.List;

import com.netease.mail.dp.des.common.api.enums.ExcelCellType;
import com.netease.mail.dp.des.process.api.entity.ExcelCell;
import com.netease.mail.yanxuan.change.common.anno.ExcelTitleName;

import lombok.Data;

/**
 * 变更配置导出VO（一层保持原样，二层新增：变更行动项部门、变更行动人、变更风险描述、行动项、变更验证措施）
 */
@Data
public class ChangeConfigExcelVo {
    
    @ExcelTitleName(title = "配置ID", order = 1)
    private Long id;
    
    @ExcelTitleName(title = "变更主体", order = 2)
    private String changeSubject;
    
    @ExcelTitleName(title = "变更类型", order = 3)
    private String changeType;
    
    @ExcelTitleName(title = "变更等级", order = 4)
    private String changeLevel;
    
    @ExcelTitleName(title = "变更负责部门", order = 5)
    private String changeDepartment;
    
    @ExcelTitleName(title = "变更执行部门", order = 6)
    private String participateChangeExecDepartment;
    
    @ExcelTitleName(title = "变更负责人类型", order = 7)
    private String changeCommanderType;
    
    @ExcelTitleName(title = "变更负责人", order = 8)
    private String changeCommander;
    
    @ExcelTitleName(title = "是否需要资料", order = 9)
    private String needFile;
    
    @ExcelTitleName(title = "创建人", order = 10)
    private String creator;
    
    @ExcelTitleName(title = "创建时间", order = 11)
    private String createTime;
    
    @ExcelTitleName(title = "更新时间", order = 12)
    private String updateTime;
    @ExcelTitleName(title = "变更行动项部门", order = 13)
    private String changeExecDepartment;
    @ExcelTitleName(title = "变更行动人", order = 14)
    private String changeExecUser;
    @ExcelTitleName(title = "变更风险描述", order = 15)
    private String changeRiskDesc;
    @ExcelTitleName(title = "行动项", order = 16)
    private String changeExecProject;
    @ExcelTitleName(title = "变更验证措施", order = 17)
    private String changeChecking;

    public static List<ExcelCell> init(ChangeConfigExcelDTO dto) {
        List<ExcelCell> cells = new ArrayList<>();
        ExcelCell excelCell;
        
        // 1. 配置ID
        excelCell = new ExcelCell();
        excelCell.setCellType(ExcelCellType.TEXT);
        excelCell.setValue(dto.getId() != null ? dto.getId().toString() : "");
        cells.add(excelCell);
        
        // 2. 变更主体
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeSubject() != null ? dto.getChangeSubject() : "");
        cells.add(excelCell);
        
        // 3. 变更类型
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeType() != null ? dto.getChangeType() : "");
        cells.add(excelCell);
        
        // 4. 变更等级
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeLevel() != null ? dto.getChangeLevel() : "");
        cells.add(excelCell);
        
        // 5. 变更负责部门
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeDepartment() != null ? dto.getChangeDepartment() : "");
        cells.add(excelCell);
        
        // 6. 变更执行部门
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getParticipateChangeExecDepartment() != null ? dto.getParticipateChangeExecDepartment() : "");
        cells.add(excelCell);
        
        // 7. 变更负责人类型
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeCommanderType() != null ? dto.getChangeCommanderType() : "");
        cells.add(excelCell);
        
        // 8. 变更负责人
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeCommander() != null ? dto.getChangeCommander() : "");
        cells.add(excelCell);
        
        // 9. 是否需要资料
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getNeedFile() != null ? dto.getNeedFile() : "");
        cells.add(excelCell);
        
        // 10. 创建人
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getCreator() != null ? dto.getCreator() : "");
        cells.add(excelCell);
        
        // 11. 创建时间
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getCreateTime() != null ? dto.getCreateTime() : "");
        cells.add(excelCell);
        
        // 12. 更新时间
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getUpdateTime() != null ? dto.getUpdateTime() : "");
        cells.add(excelCell);
        // 13. 变更行动项部门
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeExecDepartment() != null ? dto.getChangeExecDepartment() : "");
        cells.add(excelCell);
        
        // 14. 变更行动人
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeExecUser() != null ? dto.getChangeExecUser() : "");
        cells.add(excelCell);
        
        // 15. 变更风险描述
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeRiskDesc() != null ? dto.getChangeRiskDesc() : "");
        cells.add(excelCell);
        
        // 16. 行动项
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeExecProject() != null ? dto.getChangeExecProject() : "");
        cells.add(excelCell);
        
        // 17. 变更验证措施
        excelCell = new ExcelCell();
        excelCell.setValue(dto.getChangeChecking() != null ? dto.getChangeChecking() : "");
        cells.add(excelCell);
        
        return cells;
    }
}

