package com.netease.mail.yanxuan.change.biz.service.change;

import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigDeleteReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigQueryReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigReq;

/**
 * @author WangJiaXiang
 * @date 2022/11/11/011$
 */
public interface AdminChangeConfigService {

    /**
     * 查询更改配置类型列表
     * @param changeConfigQueryReq 参数
     * @return
     */
    AjaxResult queryChanges(Integer pageNum,Integer pageSize,ChangeConfigQueryReq changeConfigQueryReq);

    /**
     * 查询更改配置详情
     * @param id  模板id
     * @return
     */
    AjaxResult queryDetail(Long id,Long sonChangeClassId);

    /**
     * 新增更改类型配置模板
     * @param changeConfigReq
     * @param uid
     * @param name
     * @return
     */
    AjaxResult createChange(ChangeConfigReq changeConfigReq, String uid, String name);

    /**
     * 修改更改类型配置模板
     * @param changeConfigReq
     * @return
     */
    AjaxResult modifyChange(ChangeConfigReq changeConfigReq);

    /**
     * 删除更改类型配置模板
     * @param id
     * @return
     */
    AjaxResult deleteChange(ChangeConfigDeleteReq id);

    /**
     * 返回所有配置类型
     * @return
     */
    AjaxResult queryConfigType();
}
