package com.netease.mail.yanxuan.change.biz.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.netease.mail.yanxuan.change.biz.service.ChangeSubFlowFileService;
import com.netease.mail.yanxuan.change.common.enums.FileTypeEnum;
import com.netease.mail.yanxuan.change.dal.entity.ChangeSubFlowFile;
import com.netease.mail.yanxuan.change.dal.mapper.ChangeSubFlowFileMapper;

/**
 * 子单文件服务实现
 */
@Service
public class ChangeSubFlowFileServiceImpl implements ChangeSubFlowFileService {

    @Autowired
    private ChangeSubFlowFileMapper changeSubFlowFileMapper;

    @Override
    public void saveRecord(ChangeSubFlowFile file) {
        changeSubFlowFileMapper.insertSelective(file);
    }

    @Override
    public void batchSaveRecord(List<ChangeSubFlowFile> files) {
        changeSubFlowFileMapper.insertList(files);
    }

    @Override
    public List<ChangeSubFlowFile> getFileList(Long subFlowRecordId) {
        return changeSubFlowFileMapper.selectBySubFlowRecordId(subFlowRecordId);
    }

    @Override
    public Integer deleteBySubFlowRecordId(Long subFlowRecordId) {
        return changeSubFlowFileMapper.deleteBySubFlowRecordId(subFlowRecordId);
    }

    @Override
    public void deleteBySubFlowRecordIdAndType(Long subFlowRecordId, FileTypeEnum type) {
        changeSubFlowFileMapper.deleteBySubFlowRecordIdAndType(subFlowRecordId, type.getType());
    }
}

