/**
 * @(#)ChangeFlowFile.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.dal.meta.model.req;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class ChangeFlowFile {

    /**
     * 文件名
     */
    private String fileName;

    /**
     * 文件链接
     */
    private String fileUrl;

    /**
     * 文件类型（基础信息图片/基础信息视频/基础信息资料/变更结果资料）
     * @see com.netease.mail.yanxuan.change.common.enums.FileTypeEnum
     */
    private Integer fileType;
}