package com.netease.mail.yanxuan.change.common.util;


import java.io.BufferedReader;

import javax.servlet.http.HttpServletRequest;

import org.springframework.util.StringUtils;

/**
 * @author cyZhao
 * @date 2019/1/28
 */
public class RequestUtil {

    public static final String CHAR_SET = "UTF-8";

    private static final String POST_METHOD = "POST";

    public static String getRequestPath(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String path = request.getRequestURI();
        String queryStr = request.getQueryString();
        if (!StringUtils.isEmpty(queryStr)) {
            path = path + "?" + queryStr;
        }
        if (POST_METHOD.equals(request.getMethod().toUpperCase())) {
            String body = getRequestBody(request);
            if (!StringUtils.isEmpty(body)) {
                path += "\nbody: " + body;
            }
        }
        return path;
    }

    private static String getRequestBody(HttpServletRequest request) {
        StringBuffer json = new StringBuffer();
        String line;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                json.append(line);
            }
        } catch (Exception e) {
        }
        return json.toString();
    }

}
