/**
 * @(#)ExcelUtil.java, 2022/7/5.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.common.util;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.springframework.web.multipart.MultipartFile;

import com.netease.mail.dp.des.common.api.enums.ExcelCellType;
import com.netease.mail.dp.des.process.api.entity.ExcelCell;
import com.netease.mail.dp.des.process.api.entity.ExcelTitle;
import com.netease.mail.yanxuan.change.common.anno.ExcelTitleName;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;

/**
 * @author ysl (wb.yeshunliang01@mesg.corp.netease.com)
 */
public class ExcelUtil {

    private static final List<Field> NULL_FIELDS = Collections.emptyList();

    private static Map<Class<?>, List<Field>> annotedFieldMap = new ConcurrentHashMap<>(4);

    /**
     * 解析excel，转换成list
     * @param file
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> List<T> parseExcelList(MultipartFile file, Class<T> clazz) {
        List<T> list;
        try {
            InputStream inputStream = file.getInputStream();
            ImportParams importParams = new ImportParams();
            list = ExcelImportUtil.importExcel(inputStream, clazz, importParams);
        } catch (Exception e) {
            throw new IllegalArgumentException("上传的文件错误");
        }
        return list;
    }

    public static <T> ExcelTitle fetchExceltile(Class<T> clazz) {
        if (clazz == null) {
            throw new RuntimeException("clazz参数不能为空");
        }
        List<Field> sortedFields = fetchAnnotedFields(clazz);
        if (sortedFields == NULL_FIELDS) {
            throw new RuntimeException("未找到表头字段");
        }

        ExcelTitle excelTitle = new ExcelTitle();
        List<ExcelCell> excelCells = new ArrayList<>();
        sortedFields.forEach(field -> {
            ExcelCell excelCell = new ExcelCell();
            excelCell.setValue(field.getAnnotation(ExcelTitleName.class).title());
            excelCell.setCellType(ExcelCellType.NORMAL);
            excelCells.add(excelCell);
        });
        excelTitle.setTitle(excelCells);
        return excelTitle;
    }

    private static <T> List<Field> fetchAnnotedFields(Class<T> clazz) {
        if (annotedFieldMap.containsKey(clazz)) {
            return annotedFieldMap.get(clazz);
        }
        Field[] fields = clazz.getDeclaredFields();
        Map<Field, ExcelTitleName> fieldMap = new HashMap<>(4);
        for (Field field: fields) {
            ExcelTitleName column = field.getAnnotation(ExcelTitleName.class);
            if (column == null) {
                continue;
            }
            fieldMap.put(field, column);
        }
        if (fieldMap.isEmpty()) {
            annotedFieldMap.put(clazz, NULL_FIELDS);
            return NULL_FIELDS;
        }
        List<Field> fieldList = new ArrayList<>(fieldMap.keySet());
        Collections.sort(fieldList, (field1, field2) -> {
            ExcelTitleName column1 = fieldMap.get(field1);
            ExcelTitleName column2 = fieldMap.get(field2);
            return column1.order() - column2.order();
        });
        annotedFieldMap.put(clazz, fieldList);
        return fieldList;
    }
}