/**
 * @(#)ChangeFlowController.java, 2022/11/14.
 * <p/>
 * Copyright 2022 Netease, Inc. All rights reserved.
 * NETEASE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.netease.mail.yanxuan.change.web.controller;

import com.netease.mail.yanxuan.change.biz.biz.ChangeSubFlowBiz;
import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.dal.entity.ChangeExecRecord;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeSubFlowCreateReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeSubFlowListQueryReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeSubFlowSubmitReq;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeFlowVO;
import com.netease.mail.yanxuan.change.dal.meta.model.vo.ChangeSubFlowListVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @Author zcwang
 * @Date 2022/11/14
 */
@Slf4j
@RestController
@RequestMapping("/change/sub/flow")
public class ChangeSubFlowController {

    @Autowired
    private ChangeSubFlowBiz changeSubFlowBiz;

    /**
     * 变更行动工单列表查询,new
     *
     * @param page 页码
     * @param pageSize 每页大小
     * @param flowId 变更工单ID（主单flowId）
     * @param subFlowId 变更行动工单ID
     * @param itemId 商品ID
     * @param supplier 供应商
     * @param changeExecUser 变更行动人（姓名或邮箱）
     * @param changeExecDepartment 变更行动部门
     * @param status 行动工单状态
     * @param startTime 开始时间（行动工单发起时间）
     * @param endTime 结束时间（行动工单发起时间）
     * @param onlyMyFollowed 数据可见范围：仅查看我跟进的工单（默认true）
     * @return 变更行动工单列表
     */
    @GetMapping("/page")
    public AjaxResult<ChangeSubFlowListVO> page(@RequestParam(name = "page", defaultValue = "1") Integer page,
                                                @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                @RequestParam(name = "flowId", required = false) Long flowId,
                                                @RequestParam(name = "subFlowId", required = false) String subFlowId,
                                                @RequestParam(name = "itemId", required = false) String itemId,
                                                @RequestParam(name = "supplier", required = false) String supplier,
                                                @RequestParam(name = "changeExecUser", required = false) String changeExecUser,
                                                @RequestParam(name = "changeExecDepartment", required = false) String changeExecDepartment,
                                                @RequestParam(name = "status", required = false) Integer status,
                                                @RequestParam(name = "startTime", required = false) Long startTime,
                                                @RequestParam(name = "endTime", required = false) Long endTime,
                                                @RequestParam(name = "onlyMyFollowed", defaultValue = "true") Boolean onlyMyFollowed) {
        ChangeSubFlowListQueryReq queryReq = new ChangeSubFlowListQueryReq();
        queryReq.setFlowId(flowId);
        queryReq.setSubFlowId(subFlowId);
        queryReq.setItemId(itemId);
        queryReq.setSupplier(supplier);
        queryReq.setChangeExecUser(changeExecUser);
        queryReq.setChangeExecDepartment(changeExecDepartment);
        queryReq.setStatus(status);
        queryReq.setStartTime(startTime);
        queryReq.setEndTime(endTime);
        queryReq.setOnlyMyFollowed(onlyMyFollowed);
        return AjaxResult.success(changeSubFlowBiz.querySubFlowList(page, pageSize, queryReq));
    }

    /**
     * 变更行动工单详情查询，new
     * 说明：展示内容和主单的detail一样，但行动项只展示该变更行动工单下绑定的行动项
     *
     * @param subFlowId 变更行动工单ID（即topo）
     * @return 变更工单详情
     */
    @GetMapping("/detail")
    public AjaxResult<ChangeFlowVO> detail(@RequestParam String subFlowId) {
        return AjaxResult.success(changeSubFlowBiz.detailBySubFlowId(subFlowId));
    }

    /**
     * 子流程提交，new
     * 
     * @return
     */
    @PostMapping("/submit")
    public AjaxResult<String> submit(@RequestBody @Valid ChangeSubFlowSubmitReq changeSubFlowSubmitReq) {
        return AjaxResult.success(changeSubFlowBiz.submitSubFlow(changeSubFlowSubmitReq));
    }
}
