package com.netease.mail.yanxuan.change.integration.flow.ius;

import com.netease.mail.yanxuan.change.integration.flow.UserQueryDTO;
import com.netease.mail.yanxuan.change.integration.flow.ius.req.IusDepartmentReq;
import com.netease.mail.yanxuan.change.integration.flow.ius.rsp.IusUserInfoRsp;
import com.netease.mail.yanxuan.change.integration.flow.ius.rsp.OrgPosLeaderChainRsp;
import com.netease.mail.yanxuan.change.integration.flow.ius.rsp.SecondaryDepartments;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;
import com.netease.yanxuan.missa.client.annotation.MissaClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.HashMap;
import java.util.List;

/**
 * @author WangJiaXiang
 * @date 2022/11/24/024$
 */
@Service
@MissaClient(serviceCode = "yanxuan-ius")
public interface IusRpcService {

    /**
     * 获取指定用户信息，是否返回操作记录、关联的角色信息。当uid和userId都传时，需保证指向同一个用户。
     * @param uid
     * @return
     */
    @GetMapping("/v1/qc/user/get")
    AjaxResponse<IusUserInfoRsp> queryUserInfo(@RequestParam(name = "uid") String uid,
        @RequestParam(name = "icac") Boolean icac);

    /**
     * 获取指定用户信息，是否返回操作记录、关联的角色信息。当uid和userId都传时，需保证指向同一个用户。
     * @param query
     * @return
     */
    @PostMapping("/v1/qc/user/query")
    AjaxResponse<List<IusUserInfoRsp>> queryUserListInfo(@RequestBody UserQueryDTO query);

    /**
     * 查询指定用户部门下的上级部门(含本部门)负责人链(支持一级或多级)
     * @param uid
     * @return
     */
    /*@GetMapping("/v1/qc/allTeam/pos/queryLeaderChain")
    AjaxResponse<List<OrgPosLeaderChainRsp>> queryLeaderChain(@RequestParam(name = "uid")String uid);*/

    /**
     * 查询用户的负责人链(直接上级和所有上级)，返回(key=用户邮箱，value=用户所属所有部门的上级(包括本部门)负责人链)
     * @param uid
     * @return
     */
    @PostMapping("/v1/qc/user/queryLeaderChain")
    AjaxResponse<HashMap<String, List<SecondaryDepartments>>> queryDepartment(@RequestBody IusDepartmentReq uid);

}
