package com.netease.mail.yanxuan.change.web.controller;


import com.netease.mail.yanxuan.change.common.bean.AjaxResult;
import com.netease.mail.yanxuan.change.biz.service.change.AdminChangeConfigService;
import com.netease.mail.yanxuan.change.biz.service.DESExportService;
import com.netease.mail.yanxuan.change.common.bean.RequestLocalBean;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigDeleteReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigQueryReq;
import com.netease.mail.yanxuan.change.dal.meta.model.req.ChangeConfigReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.FlowRpcSupplierSendService;
import com.netease.mail.yanxuan.change.integration.flow.supplier.req.SupplierSearchRemoteReq;
import com.netease.mail.yanxuan.change.integration.flow.supplier.rsp.SupplierSimpleRsp;
import com.netease.yanxuan.flowx.sdk.meta.controller.communal.AjaxResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import java.util.ArrayList;
import java.util.List;


/**
 * @author WangJiaXiang
 * @date 2022/11/11/011$
 */
@RestController
@RequestMapping("/config/change")
public class ChangeConfigController {

    @Autowired
    private AdminChangeConfigService service;

    @Autowired
    private FlowRpcSupplierSendService supplierSendService;
    
    @Autowired
    private DESExportService desExportService;

    /**
     * 通过参数查询配置模板
     * @return
     */
    @GetMapping("/list")
    public AjaxResult queryChanges(
            @RequestParam(name = "page",defaultValue = "1") Integer page,
            @RequestParam(name = "pageSize",defaultValue = "10")Integer pageSize,
            @RequestParam(name = "changeDepartment",required = false) String changeDepartment,
            @RequestParam(name = "changeExecDepartment",required = false) String changeExecDepartment,
            @RequestParam(name = "parentChangeClassId",required = false)Integer parentChangeClassId,
            @RequestParam(name = "sonChangeClassId",required = false)Integer sonChangeClassId,
            @RequestParam(name = "changeLevel",required = false)Integer changeLevel,
            @RequestParam(name = "createTime",required = false)Long createTime,
            @RequestParam(name = "endTime",required = false)Long endTime){
        ChangeConfigQueryReq req = new ChangeConfigQueryReq();
        req.setChangeDepartment(changeDepartment);
        req.setChangeExecDepartment(changeExecDepartment);
        req.setParentChangeClassId(parentChangeClassId);
        req.setSonChangeClassId(sonChangeClassId);
        req.setChangeLevel(changeLevel);
        req.setCreateTime(createTime);
        req.setUpdateTime(endTime);
        return service.queryChanges(page,pageSize,req);
    }

    /**
     * 查询变更模板详情
     * @param id
     * @return
     */
    @GetMapping("/detail")
    public AjaxResult queryDetail(
            @RequestParam(name = "id",required = false) Long id,
            @RequestParam(name = "sonChangeClassId",required = false) Long sonChangeClassId){
        return service.queryDetail(id,sonChangeClassId);
    }

    /**
     * 新增变更模板详情
     * @param changeConfigReq
     * @return
     */
    @PostMapping("/create")
    public AjaxResult createChange(
            @RequestBody ChangeConfigReq changeConfigReq){
        String name = RequestLocalBean.getName();
        String uid = RequestLocalBean.getUid();
        return service.createChange(changeConfigReq, uid, name);
    }

    /**
     * 修改变更模板详情
     * @param changeConfigReq
     * @return
     */
    @PostMapping("/modify")
    public AjaxResult modifyChange(
            @RequestBody ChangeConfigReq changeConfigReq){
        return service.modifyChange(changeConfigReq);
    }

    /**
     * 删除模板配置
     * @param id
     * @return
     */
    @PostMapping("/delete")
    public AjaxResult deleteChange(
            @RequestBody ChangeConfigDeleteReq id){
        return service.deleteChange(id);
    }

    /**
     * 查询所有模板配置类型
     * @return
     */
    @GetMapping("/query/config/type")
    public AjaxResult queryConfigType(){
        return service.queryConfigType();
    }


    /**
     * 跟进供应商名称模糊查询
     */
    @GetMapping("/query/supplier/infos")
    public AjaxResponse<List<SupplierSimpleRsp>> queryByConditionForQc(@RequestParam(name = "searchText") String searchText){
        SupplierSearchRemoteReq req = new SupplierSearchRemoteReq();
        req.setSearchText(searchText);
        //暂时使用模拟数据
        //AjaxResponse<List<SupplierSimpleRsp>> listAjaxResponse = service.queryByConditionForQc(req);
        AjaxResponse<List<SupplierSimpleRsp>> listAjaxResponse = new AjaxResponse<List<SupplierSimpleRsp>>();
        List<SupplierSimpleRsp> suppliers = new ArrayList<>();
        SupplierSimpleRsp supplierSimpleRsp1 = new SupplierSimpleRsp("YX0778","gyhtest1009");
        SupplierSimpleRsp supplierSimpleRsp2 = new SupplierSimpleRsp("YX0528","gyhtest1010");
        suppliers.add(supplierSimpleRsp1);
        suppliers.add(supplierSimpleRsp2);
        listAjaxResponse.setData(suppliers);
        listAjaxResponse.setCode(200);
        //return supplierSendService.queryByConditionForQc(req);  暂用模拟数据
        return listAjaxResponse;
    }
    
    /**
     * 导出变更配置列表
     * 
     * @return
     */
    @GetMapping("/export")
    public AjaxResult<String> export(
            @RequestParam(name = "changeDepartment", required = false) String changeDepartment,
            @RequestParam(name = "changeExecDepartment", required = false) String changeExecDepartment,
            @RequestParam(name = "parentChangeClassId", required = false) Integer parentChangeClassId,
            @RequestParam(name = "sonChangeClassId", required = false) Integer sonChangeClassId,
            @RequestParam(name = "changeLevel", required = false) Integer changeLevel,
            @RequestParam(name = "createTime", required = false) Long createTime,
            @RequestParam(name = "endTime", required = false) Long endTime,
            @RequestParam(name = "serviceCode") String serviceCode) {
        ChangeConfigQueryReq req = new ChangeConfigQueryReq();
        req.setChangeDepartment(changeDepartment);
        req.setChangeExecDepartment(changeExecDepartment);
        req.setParentChangeClassId(parentChangeClassId);
        req.setSonChangeClassId(sonChangeClassId);
        req.setChangeLevel(changeLevel);
        req.setCreateTime(createTime);
        req.setUpdateTime(endTime);
        String uid = RequestLocalBean.getUid();
        String result = desExportService.changeConfigExport(req, uid, serviceCode);
        return AjaxResult.success(result);
    }
}
